/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.select;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.select.PagingOffset;
import org.apache.druid.query.select.SelectQueryConfig;

public class PagingSpec {
    private final Map<String, Integer> pagingIdentifiers;
    private final int threshold;
    private final boolean fromNext;

    public static PagingSpec newSpec(int threshold) {
        return new PagingSpec(null, threshold);
    }

    public static Map<String, Integer> merge(Iterable<Map<String, Integer>> cursors) {
        HashMap next = Maps.newHashMap();
        for (Map<String, Integer> cursor : cursors) {
            for (Map.Entry<String, Integer> entry : cursor.entrySet()) {
                next.put(entry.getKey(), entry.getValue());
            }
        }
        return next;
    }

    public static Map<String, Integer> next(Map<String, Integer> cursor, boolean descending) {
        for (Map.Entry<String, Integer> entry : cursor.entrySet()) {
            entry.setValue(descending ? entry.getValue() - 1 : entry.getValue() + 1);
        }
        return cursor;
    }

    @JsonCreator
    public PagingSpec(@JsonProperty(value="pagingIdentifiers") Map<String, Integer> pagingIdentifiers, @JsonProperty(value="threshold") int threshold, @JsonProperty(value="fromNext") Boolean fromNext, @JacksonInject SelectQueryConfig config) {
        this.pagingIdentifiers = pagingIdentifiers == null ? Maps.newHashMap() : pagingIdentifiers;
        this.threshold = threshold;
        boolean defaultFromNext = config.getEnableFromNextDefault();
        this.fromNext = fromNext == null ? defaultFromNext : fromNext;
    }

    public PagingSpec(Map<String, Integer> pagingIdentifiers, int threshold) {
        this(pagingIdentifiers, threshold, null, new SelectQueryConfig(true));
    }

    public PagingSpec(Map<String, Integer> pagingIdentifiers, int threshold, Boolean fromNext) {
        this(pagingIdentifiers, threshold, fromNext, new SelectQueryConfig(true));
    }

    @JsonProperty
    public Map<String, Integer> getPagingIdentifiers() {
        return this.pagingIdentifiers;
    }

    @JsonProperty
    public int getThreshold() {
        return this.threshold;
    }

    @JsonProperty
    public boolean isFromNext() {
        return this.fromNext;
    }

    public byte[] getCacheKey() {
        byte[][] pagingKeys = new byte[this.pagingIdentifiers.size()][];
        byte[][] pagingValues = new byte[this.pagingIdentifiers.size()][];
        int index = 0;
        int pagingKeysSize = 0;
        int pagingValuesSize = 0;
        for (Map.Entry<String, Integer> entry : this.pagingIdentifiers.entrySet()) {
            pagingKeys[index] = StringUtils.toUtf8((String)entry.getKey());
            pagingValues[index] = ByteBuffer.allocate(4).putInt(entry.getValue()).array();
            pagingKeysSize += pagingKeys[index].length;
            pagingValuesSize += 4;
            ++index;
        }
        byte[] thresholdBytes = ByteBuffer.allocate(4).putInt(this.threshold).array();
        ByteBuffer queryCacheKey = ByteBuffer.allocate(pagingKeysSize + pagingValuesSize + thresholdBytes.length + 1);
        for (byte[] pagingKey : pagingKeys) {
            queryCacheKey.put(pagingKey);
        }
        for (byte[] pagingValue : pagingValues) {
            queryCacheKey.put(pagingValue);
        }
        queryCacheKey.put(thresholdBytes);
        queryCacheKey.put(this.isFromNext() ? (byte)1 : 0);
        return queryCacheKey.array();
    }

    public PagingOffset getOffset(String identifier, boolean descending) {
        Integer offset = this.pagingIdentifiers.get(identifier);
        if (offset == null) {
            offset = PagingOffset.toOffset(0, descending);
        } else if (this.fromNext) {
            offset = descending ? offset - 1 : offset + 1;
        }
        return PagingOffset.of(offset, this.threshold);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PagingSpec that = (PagingSpec)o;
        if (this.fromNext != that.fromNext) {
            return false;
        }
        if (this.threshold != that.threshold) {
            return false;
        }
        return this.pagingIdentifiers.equals(that.pagingIdentifiers);
    }

    public int hashCode() {
        int result = this.pagingIdentifiers.hashCode();
        result = 31 * result + this.threshold;
        result = 31 * result + (this.fromNext ? 1 : 0);
        return result;
    }

    public String toString() {
        return "PagingSpec{pagingIdentifiers=" + this.pagingIdentifiers + ", threshold=" + this.threshold + ", fromNext=" + this.fromNext + '}';
    }
}

