/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ZeroIndexedInts;
import org.apache.druid.segment.filter.BooleanValueMatcher;
import org.apache.druid.segment.historical.SingleValueHistoricalDimensionSelector;

public class NullDimensionSelector
implements SingleValueHistoricalDimensionSelector,
IdLookup {
    private static final NullDimensionSelector INSTANCE = new NullDimensionSelector();

    private NullDimensionSelector() {
    }

    public static NullDimensionSelector instance() {
        return INSTANCE;
    }

    @Override
    public IndexedInts getRow() {
        return ZeroIndexedInts.instance();
    }

    @Override
    public int getRowValue(int offset) {
        return 0;
    }

    @Override
    public IndexedInts getRow(int offset) {
        return this.getRow();
    }

    @Override
    public ValueMatcher makeValueMatcher(@Nullable String value) {
        return BooleanValueMatcher.of(value == null);
    }

    @Override
    public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
        return BooleanValueMatcher.of(predicate.apply(null));
    }

    @Override
    public int getValueCardinality() {
        return 1;
    }

    @Override
    @Nullable
    public String lookupName(int id) {
        assert (id == 0) : "id = " + id;
        return null;
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return true;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return this;
    }

    @Override
    public int lookupId(@Nullable String name) {
        return NullHandling.isNullOrEquivalent((String)name) ? 0 : -1;
    }

    @Override
    @Nullable
    public Object getObject() {
        return null;
    }

    @Override
    public Class classOfObject() {
        return Object.class;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
    }
}

