/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.io.Closeable;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.SingleScanTimeDimensionSelector;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.ReadableOffset;

class QueryableIndexColumnSelectorFactory
implements ColumnSelectorFactory {
    private final QueryableIndex index;
    private final VirtualColumns virtualColumns;
    private final boolean descending;
    private final Closer closer;
    protected final ReadableOffset offset;
    private final Map<String, BaseColumn> columnCache;

    QueryableIndexColumnSelectorFactory(QueryableIndex index, VirtualColumns virtualColumns, boolean descending, Closer closer, ReadableOffset offset, Map<String, BaseColumn> columnCache) {
        this.index = index;
        this.virtualColumns = virtualColumns;
        this.descending = descending;
        this.closer = closer;
        this.offset = offset;
        this.columnCache = columnCache;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        if (this.virtualColumns.exists(dimensionSpec.getDimension())) {
            return this.virtualColumns.makeDimensionSelector(dimensionSpec, this);
        }
        return dimensionSpec.decorate(this.makeDimensionSelectorUndecorated(dimensionSpec));
    }

    private DimensionSelector makeDimensionSelectorUndecorated(DimensionSpec dimensionSpec) {
        String dimension = dimensionSpec.getDimension();
        ExtractionFn extractionFn = dimensionSpec.getExtractionFn();
        ColumnHolder columnHolder = this.index.getColumnHolder(dimension);
        if (columnHolder == null) {
            return DimensionSelectorUtils.constantSelector(null, extractionFn);
        }
        if (dimension.equals("__time")) {
            return new SingleScanTimeDimensionSelector(this.makeColumnValueSelector(dimension), extractionFn, this.descending);
        }
        ValueType type = columnHolder.getCapabilities().getType();
        if (type.isNumeric()) {
            return type.makeNumericWrappingDimensionSelector(this.makeColumnValueSelector(dimension), extractionFn);
        }
        BaseColumn column = this.columnCache.computeIfAbsent(dimension, d -> {
            BaseColumn col = columnHolder.getColumn();
            if (col instanceof DictionaryEncodedColumn) {
                return (BaseColumn)this.closer.register((Closeable)col);
            }
            return null;
        });
        if (column instanceof DictionaryEncodedColumn) {
            return ((DictionaryEncodedColumn)column).makeDimensionSelector(this.offset, extractionFn);
        }
        return DimensionSelectorUtils.constantSelector(null, extractionFn);
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.makeColumnValueSelector(columnName, this);
        }
        BaseColumn column = this.columnCache.computeIfAbsent(columnName, name -> {
            ColumnHolder holder = this.index.getColumnHolder((String)name);
            if (holder != null) {
                return (BaseColumn)this.closer.register((Closeable)holder.getColumn());
            }
            return null;
        });
        if (column != null) {
            return column.makeColumnValueSelector(this.offset);
        }
        return NilColumnValueSelector.instance();
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.getColumnCapabilities(columnName);
        }
        return QueryableIndexStorageAdapter.getColumnCapabilities(this.index, columnName);
    }
}

