/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.segment.AbstractSegment;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.StorageAdapter;
import org.joda.time.Interval;

public class ReferenceCountingSegment
extends AbstractSegment {
    private static final EmittingLogger log = new EmittingLogger(ReferenceCountingSegment.class);
    private final Segment baseSegment;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Phaser referents = new Phaser(1){

        @Override
        protected boolean onAdvance(int phase, int registeredParties) {
            Preconditions.checkState((registeredParties == 0 ? 1 : 0) != 0);
            try {
                ReferenceCountingSegment.this.baseSegment.close();
            }
            catch (Exception e) {
                try {
                    log.error((Throwable)e, "Exception while closing segment[%s]", new Object[]{ReferenceCountingSegment.this.baseSegment.getIdentifier()});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
    };

    public ReferenceCountingSegment(Segment baseSegment) {
        this.baseSegment = baseSegment;
    }

    public Segment getBaseSegment() {
        return !this.isClosed() ? this.baseSegment : null;
    }

    public int getNumReferences() {
        return Math.max(this.referents.getRegisteredParties() - 1, 0);
    }

    public boolean isClosed() {
        return this.referents.isTerminated();
    }

    @Override
    public String getIdentifier() {
        return !this.isClosed() ? this.baseSegment.getIdentifier() : null;
    }

    @Override
    public Interval getDataInterval() {
        return !this.isClosed() ? this.baseSegment.getDataInterval() : null;
    }

    @Override
    public QueryableIndex asQueryableIndex() {
        return !this.isClosed() ? this.baseSegment.asQueryableIndex() : null;
    }

    @Override
    public StorageAdapter asStorageAdapter() {
        return !this.isClosed() ? this.baseSegment.asStorageAdapter() : null;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.referents.arriveAndDeregister();
        } else {
            log.warn("close() is called more than once on ReferenceCountingSegment", new Object[0]);
        }
    }

    public boolean increment() {
        return this.referents.register() >= 0;
    }

    public Closeable decrementOnceCloseable() {
        AtomicBoolean decremented = new AtomicBoolean(false);
        return () -> {
            if (decremented.compareAndSet(false, true)) {
                this.decrement();
            } else {
                log.warn("close() is called more than once on ReferenceCountingSegment.decrementOnceCloseable()", new Object[0]);
            }
        };
    }

    public void decrement() {
        this.referents.arriveAndDeregister();
    }

    @Override
    public <T> T as(Class<T> clazz) {
        return this.getBaseSegment().as(clazz);
    }
}

