/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.BitmapIndex;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.NumericColumn;
import org.apache.druid.segment.column.SimpleColumnHolder;
import org.apache.druid.segment.column.SpatialIndex;
import org.apache.druid.segment.column.ValueType;

public class ColumnBuilder {
    private ValueType type = null;
    private boolean hasMultipleValues = false;
    private boolean filterable = false;
    private Supplier<? extends BaseColumn> columnSupplier = null;
    private boolean dictionaryEncoded = false;
    private Supplier<BitmapIndex> bitmapIndex = null;
    private Supplier<SpatialIndex> spatialIndex = null;
    private SmooshedFileMapper fileMapper = null;

    public ColumnBuilder setFileMapper(SmooshedFileMapper fileMapper) {
        this.fileMapper = fileMapper;
        return this;
    }

    public SmooshedFileMapper getFileMapper() {
        return this.fileMapper;
    }

    public ColumnBuilder setType(ValueType type) {
        this.type = type;
        return this;
    }

    public ColumnBuilder setHasMultipleValues(boolean hasMultipleValues) {
        this.hasMultipleValues = hasMultipleValues;
        return this;
    }

    public ColumnBuilder setDictionaryEncodedColumnSupplier(Supplier<? extends DictionaryEncodedColumn<?>> columnSupplier) {
        this.columnSupplier = columnSupplier;
        this.dictionaryEncoded = true;
        return this;
    }

    public ColumnBuilder setFilterable(boolean filterable) {
        this.filterable = filterable;
        return this;
    }

    public ColumnBuilder setComplexColumnSupplier(Supplier<? extends ComplexColumn> columnSupplier) {
        this.columnSupplier = columnSupplier;
        return this;
    }

    public ColumnBuilder setNumericColumnSupplier(Supplier<? extends NumericColumn> columnSupplier) {
        this.columnSupplier = columnSupplier;
        return this;
    }

    public ColumnBuilder setBitmapIndex(Supplier<BitmapIndex> bitmapIndex) {
        this.bitmapIndex = bitmapIndex;
        return this;
    }

    public ColumnBuilder setSpatialIndex(Supplier<SpatialIndex> spatialIndex) {
        this.spatialIndex = spatialIndex;
        return this;
    }

    public ColumnHolder build() {
        Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"Type must be set.");
        return new SimpleColumnHolder(new ColumnCapabilitiesImpl().setType(this.type).setDictionaryEncoded(this.dictionaryEncoded).setHasBitmapIndexes(this.bitmapIndex != null).setHasSpatialIndexes(this.spatialIndex != null).setHasMultipleValues(this.hasMultipleValues).setFilterable(this.filterable), this.columnSupplier, this.bitmapIndex, this.spatialIndex);
    }
}

