/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.NoSuchElementException;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.LikeDimFilter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.BitmapIndex;
import org.apache.druid.segment.data.CloseableIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.filter.Filters;

public class LikeFilter
implements Filter {
    private final String dimension;
    private final ExtractionFn extractionFn;
    private final LikeDimFilter.LikeMatcher likeMatcher;

    public LikeFilter(String dimension, ExtractionFn extractionFn, LikeDimFilter.LikeMatcher likeMatcher) {
        this.dimension = dimension;
        this.extractionFn = extractionFn;
        this.likeMatcher = likeMatcher;
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        return bitmapResultFactory.unionDimensionValueBitmaps(this.getBitmapIterable(selector));
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector selector) {
        return Filters.estimateSelectivity(this.getBitmapIterable(selector).iterator(), selector.getNumRows());
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.dimension, this.likeMatcher.predicateFactory(this.extractionFn));
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return selector.getBitmapIndex(this.dimension) != null;
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return Filters.supportsSelectivityEstimation(this, this.dimension, columnSelector, indexSelector);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Iterable<ImmutableBitmap> getBitmapIterable(BitmapIndexSelector selector) {
        if (this.isSimpleEquals()) {
            return ImmutableList.of((Object)selector.getBitmapIndex(this.dimension, NullHandling.emptyToNullIfNeeded((String)this.likeMatcher.getPrefix())));
        }
        if (!this.isSimplePrefix()) return Filters.matchPredicateNoUnion(this.dimension, selector, this.likeMatcher.predicateFactory(this.extractionFn).makeStringPredicate());
        BitmapIndex bitmapIndex = selector.getBitmapIndex(this.dimension);
        if (bitmapIndex == null) {
            ImmutableBitmap immutableBitmap;
            if (this.likeMatcher.matches(null)) {
                immutableBitmap = Filters.allTrue(selector);
                return ImmutableList.of((Object)immutableBitmap);
            }
            immutableBitmap = Filters.allFalse(selector);
            return ImmutableList.of((Object)immutableBitmap);
        }
        try (CloseableIndexed<String> dimValues = selector.getDimensionValues(this.dimension);){
            Iterable<ImmutableBitmap> iterable = Filters.bitmapsFromIndexes(this.getDimValueIndexIterableForPrefixMatch(bitmapIndex, dimValues), bitmapIndex);
            return iterable;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean isSimpleEquals() {
        return this.extractionFn == null && this.likeMatcher.getSuffixMatch() == LikeDimFilter.LikeMatcher.SuffixMatch.MATCH_EMPTY;
    }

    private boolean isSimplePrefix() {
        return this.extractionFn == null && !this.likeMatcher.getPrefix().isEmpty();
    }

    private IntIterable getDimValueIndexIterableForPrefixMatch(BitmapIndex bitmapIndex, final Indexed<String> dimValues) {
        int endIndex;
        int startIndex;
        String lower = NullHandling.nullToEmptyIfNeeded((String)this.likeMatcher.getPrefix());
        String upper = NullHandling.nullToEmptyIfNeeded((String)this.likeMatcher.getPrefix()) + '\uffff';
        if (lower == null) {
            startIndex = bitmapIndex.getIndex(null);
            endIndex = startIndex + 1;
        } else {
            int lowerFound = bitmapIndex.getIndex(lower);
            startIndex = lowerFound >= 0 ? lowerFound : -(lowerFound + 1);
            int upperFound = bitmapIndex.getIndex(upper);
            endIndex = upperFound >= 0 ? upperFound + 1 : -(upperFound + 1);
        }
        return new IntIterable(){

            public IntIterator iterator() {
                return new IntIterator(){
                    int currIndex;
                    int found;
                    {
                        this.currIndex = startIndex;
                        this.found = -1;
                        this.found = this.findNext();
                    }

                    private int findNext() {
                        while (this.currIndex < endIndex && !LikeFilter.this.likeMatcher.matchesSuffixOnly(dimValues, this.currIndex)) {
                            ++this.currIndex;
                        }
                        if (this.currIndex < endIndex) {
                            return this.currIndex++;
                        }
                        return -1;
                    }

                    public boolean hasNext() {
                        return this.found != -1;
                    }

                    public int nextInt() {
                        int cur = this.found;
                        if (cur == -1) {
                            throw new NoSuchElementException();
                        }
                        this.found = this.findNext();
                        return cur;
                    }
                };
            }
        };
    }
}

