/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.serde.ComplexMetricSerde;

public class ComplexMetrics {
    private static final Map<String, ComplexMetricSerde> complexSerializers = Maps.newHashMap();

    @Nullable
    public static ComplexMetricSerde getSerdeForType(String type) {
        return complexSerializers.get(type);
    }

    public static void registerSerde(String type, ComplexMetricSerde serde) {
        if (complexSerializers.containsKey(type)) {
            throw new ISE("Serializer for type[%s] already exists.", new Object[]{type});
        }
        complexSerializers.put(type, serde);
    }
}

