/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.expression.ExprUtils;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.ConstantExprEvalSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.NullDimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.virtual.ExpressionColumnValueSelector;
import org.apache.druid.segment.virtual.SingleLongInputCachingExpressionColumnValueSelector;
import org.apache.druid.segment.virtual.SingleStringInputCachingExpressionColumnValueSelector;
import org.apache.druid.segment.virtual.SingleStringInputDimensionSelector;

public class ExpressionSelectors {
    private ExpressionSelectors() {
    }

    public static ColumnValueSelector makeColumnValueSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression) {
        final ColumnValueSelector<ExprEval> baseSelector = ExpressionSelectors.makeExprEvalSelector(columnSelectorFactory, expression);
        return new ColumnValueSelector(){

            @Override
            public double getDouble() {
                return baseSelector.getDouble();
            }

            @Override
            public float getFloat() {
                return baseSelector.getFloat();
            }

            @Override
            public long getLong() {
                return baseSelector.getLong();
            }

            @Override
            public boolean isNull() {
                return baseSelector.isNull();
            }

            @Override
            @Nullable
            public Object getObject() {
                return ((ExprEval)baseSelector.getObject()).value();
            }

            @Override
            public Class classOfObject() {
                return Object.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("baseSelector", baseSelector);
            }
        };
    }

    public static ColumnValueSelector<ExprEval> makeExprEvalSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression) {
        Expr.ObjectBinding bindings;
        List columns = Parser.findRequiredBindings((Expr)expression);
        if (columns.size() == 1) {
            String column = (String)Iterables.getOnlyElement((Iterable)columns);
            ColumnCapabilities capabilities = columnSelectorFactory.getColumnCapabilities(column);
            if (column.equals("__time")) {
                return new SingleLongInputCachingExpressionColumnValueSelector(columnSelectorFactory.makeColumnValueSelector("__time"), expression);
            }
            if (capabilities != null && capabilities.getType() == ValueType.STRING && capabilities.isDictionaryEncoded()) {
                return new SingleStringInputCachingExpressionColumnValueSelector(columnSelectorFactory.makeDimensionSelector(new DefaultDimensionSpec(column, column, ValueType.STRING)), expression);
            }
        }
        if ((bindings = ExpressionSelectors.createBindings(expression, columnSelectorFactory)).equals(ExprUtils.nilBindings())) {
            return new ConstantExprEvalSelector(expression.eval(bindings));
        }
        return new ExpressionColumnValueSelector(expression, bindings);
    }

    public static DimensionSelector makeDimensionSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression, final ExtractionFn extractionFn) {
        String column;
        ColumnCapabilities capabilities;
        List columns = Parser.findRequiredBindings((Expr)expression);
        if (columns.size() == 1 && (capabilities = columnSelectorFactory.getColumnCapabilities(column = (String)Iterables.getOnlyElement((Iterable)columns))) != null && capabilities.getType() == ValueType.STRING && capabilities.isDictionaryEncoded()) {
            return new SingleStringInputDimensionSelector(columnSelectorFactory.makeDimensionSelector(new DefaultDimensionSpec(column, column, ValueType.STRING)), expression);
        }
        final ColumnValueSelector<ExprEval> baseSelector = ExpressionSelectors.makeExprEvalSelector(columnSelectorFactory, expression);
        if (baseSelector instanceof ConstantExprEvalSelector) {
            return DimensionSelectorUtils.constantSelector(((ExprEval)baseSelector.getObject()).asString(), extractionFn);
        }
        if (baseSelector instanceof NilColumnValueSelector) {
            return NullDimensionSelector.instance();
        }
        if (extractionFn == null) {
            class DefaultExpressionDimensionSelector
            extends BaseSingleValueDimensionSelector {
                final /* synthetic */ ColumnValueSelector val$baseSelector;

                DefaultExpressionDimensionSelector(ColumnValueSelector columnValueSelector) {
                    this.val$baseSelector = columnValueSelector;
                }

                @Override
                protected String getValue() {
                    return NullHandling.emptyToNullIfNeeded((String)((ExprEval)this.val$baseSelector.getObject()).asString());
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("baseSelector", this.val$baseSelector);
                }
            }
            return new DefaultExpressionDimensionSelector(baseSelector);
        }
        class ExtractionExpressionDimensionSelector
        extends BaseSingleValueDimensionSelector {
            ExtractionExpressionDimensionSelector() {
            }

            @Override
            protected String getValue() {
                return extractionFn.apply(NullHandling.emptyToNullIfNeeded((String)((ExprEval)baseSelector.getObject()).asString()));
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("baseSelector", baseSelector);
                inspector.visit("extractionFn", extractionFn);
            }
        }
        return new ExtractionExpressionDimensionSelector();
    }

    private static Expr.ObjectBinding createBindings(Expr expression, ColumnSelectorFactory columnSelectorFactory) {
        HashMap suppliers = Maps.newHashMap();
        for (String columnName : Parser.findRequiredBindings((Expr)expression)) {
            Object supplier;
            ColumnValueSelector selector;
            ValueType nativeType;
            ColumnCapabilities columnCapabilities = columnSelectorFactory.getColumnCapabilities(columnName);
            ValueType valueType = nativeType = columnCapabilities != null ? columnCapabilities.getType() : null;
            if (nativeType == ValueType.FLOAT) {
                selector = columnSelectorFactory.makeColumnValueSelector(columnName);
                supplier = ExpressionSelectors.makeNullableSupplier(selector, selector::getFloat);
            } else if (nativeType == ValueType.LONG) {
                selector = columnSelectorFactory.makeColumnValueSelector(columnName);
                supplier = ExpressionSelectors.makeNullableSupplier(selector, selector::getLong);
            } else if (nativeType == ValueType.DOUBLE) {
                selector = columnSelectorFactory.makeColumnValueSelector(columnName);
                supplier = ExpressionSelectors.makeNullableSupplier(selector, selector::getDouble);
            } else {
                supplier = nativeType == ValueType.STRING ? ExpressionSelectors.supplierFromDimensionSelector(columnSelectorFactory.makeDimensionSelector(new DefaultDimensionSpec(columnName, columnName))) : (nativeType == null ? ExpressionSelectors.supplierFromObjectSelector(columnSelectorFactory.makeColumnValueSelector(columnName)) : null);
            }
            if (supplier == null) continue;
            suppliers.put(columnName, supplier);
        }
        if (suppliers.isEmpty()) {
            return ExprUtils.nilBindings();
        }
        if (suppliers.size() == 1) {
            String column = (String)Iterables.getOnlyElement(suppliers.keySet());
            Supplier supplier = (Supplier)Iterables.getOnlyElement(suppliers.values());
            return identifierName -> {
                assert (column.equals(identifierName));
                return supplier.get();
            };
        }
        return Parser.withSuppliers((Map)suppliers);
    }

    private static <T> Supplier<T> makeNullableSupplier(ColumnValueSelector selector, Supplier<T> supplier) {
        if (NullHandling.replaceWithDefault()) {
            return supplier;
        }
        return () -> {
            if (selector.isNull()) {
                return null;
            }
            return supplier.get();
        };
    }

    @Nonnull
    @VisibleForTesting
    static Supplier<Object> supplierFromDimensionSelector(DimensionSelector selector) {
        Preconditions.checkNotNull((Object)selector, (Object)"selector");
        return () -> {
            IndexedInts row = selector.getRow();
            if (row.size() == 1) {
                return selector.lookupName(row.get(0));
            }
            return null;
        };
    }

    @Nullable
    static Supplier<Object> supplierFromObjectSelector(BaseObjectColumnValueSelector<?> selector) {
        Class<Object> clazz;
        block6: {
            block5: {
                if (selector instanceof NilColumnValueSelector) {
                    return null;
                }
                clazz = selector.classOfObject();
                if (Number.class.isAssignableFrom(clazz)) break block5;
                if (!String.class.isAssignableFrom(clazz)) break block6;
            }
            return selector::getObject;
        }
        if (clazz.isAssignableFrom(Number.class) || clazz.isAssignableFrom(String.class)) {
            return () -> {
                Object val = selector.getObject();
                if (val instanceof Number || val instanceof String) {
                    return val;
                }
                return null;
            };
        }
        return null;
    }
}

