/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.druid.guice.ConfigModule;
import org.apache.druid.guice.DruidGuiceExtensions;
import org.apache.druid.guice.DruidSecondaryModule;
import org.apache.druid.guice.ExtensionsConfig;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.ModulesConfig;
import org.apache.druid.guice.NullHandlingModule;
import org.apache.druid.guice.PropertiesModule;
import org.apache.druid.guice.RuntimeInfoModule;
import org.apache.druid.jackson.JacksonModule;

public class GuiceInjectors {
    public static Collection<Module> makeDefaultStartupModules() {
        return ImmutableList.of((Object)new DruidGuiceExtensions(), (Object)new JacksonModule(), (Object)new PropertiesModule(Arrays.asList("common.runtime.properties", "runtime.properties")), (Object)new RuntimeInfoModule(), (Object)new ConfigModule(), (Object)new NullHandlingModule(), binder -> {
            binder.bind(DruidSecondaryModule.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.extensions", ExtensionsConfig.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.modules", ModulesConfig.class);
        });
    }

    public static Injector makeStartupInjector() {
        return Guice.createInjector(GuiceInjectors.makeDefaultStartupModules());
    }

    public static Injector makeStartupInjectorWithModules(Iterable<? extends Module> modules) {
        ArrayList<Module> theModules = new ArrayList<Module>();
        theModules.addAll(GuiceInjectors.makeDefaultStartupModules());
        for (Module module : modules) {
            theModules.add(module);
        }
        return Guice.createInjector(theModules);
    }
}

