/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.AbstractPrioritizedCallable;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryHelper;
import org.apache.druid.segment.incremental.IncrementalIndex;

public class GroupByMergedQueryRunner<T>
implements QueryRunner<T> {
    private static final Logger log = new Logger(GroupByMergedQueryRunner.class);
    private final Iterable<QueryRunner<T>> queryables;
    private final ListeningExecutorService exec;
    private final Supplier<GroupByQueryConfig> configSupplier;
    private final QueryWatcher queryWatcher;
    private final NonBlockingPool<ByteBuffer> bufferPool;

    public GroupByMergedQueryRunner(ExecutorService exec, Supplier<GroupByQueryConfig> configSupplier, QueryWatcher queryWatcher, NonBlockingPool<ByteBuffer> bufferPool, Iterable<QueryRunner<T>> queryables) {
        this.exec = MoreExecutors.listeningDecorator((ExecutorService)exec);
        this.queryWatcher = queryWatcher;
        this.queryables = Iterables.unmodifiableIterable((Iterable)Iterables.filter(queryables, (Predicate)Predicates.notNull()));
        this.configSupplier = configSupplier;
        this.bufferPool = bufferPool;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, final Map<String, Object> responseContext) {
        final GroupByQuery query = (GroupByQuery)queryPlus.getQuery();
        GroupByQueryConfig querySpecificConfig = ((GroupByQueryConfig)this.configSupplier.get()).withOverrides(query);
        final boolean isSingleThreaded = querySpecificConfig.isSingleThreaded();
        final Pair indexAccumulatorPair = GroupByQueryHelper.createIndexAccumulatorPair(query, querySpecificConfig, this.bufferPool, true);
        final Pair bySegmentAccumulatorPair = GroupByQueryHelper.createBySegmentAccumulatorPair();
        final boolean bySegment = QueryContexts.isBySegment(query);
        final int priority = QueryContexts.getPriority(query);
        final QueryPlus<T> threadSafeQueryPlus = queryPlus.withoutThreadUnsafeState();
        ListenableFuture futures = Futures.allAsList((Iterable)Lists.newArrayList((Iterable)Iterables.transform(this.queryables, (Function)new Function<QueryRunner<T>, ListenableFuture<Void>>(){

            public ListenableFuture<Void> apply(final QueryRunner<T> input) {
                if (input == null) {
                    throw new ISE("Null queryRunner! Looks to be some segment unmapping action happening", new Object[0]);
                }
                ListenableFuture future = GroupByMergedQueryRunner.this.exec.submit((Callable)new AbstractPrioritizedCallable<Void>(priority){

                    @Override
                    public Void call() {
                        try {
                            if (bySegment) {
                                input.run(threadSafeQueryPlus, responseContext).accumulate(bySegmentAccumulatorPair.lhs, (Accumulator)bySegmentAccumulatorPair.rhs);
                            } else {
                                input.run(threadSafeQueryPlus, responseContext).accumulate(indexAccumulatorPair.lhs, (Accumulator)indexAccumulatorPair.rhs);
                            }
                            return null;
                        }
                        catch (QueryInterruptedException e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                        catch (Exception e) {
                            log.error((Throwable)e, "Exception with one of the sequences!", new Object[0]);
                            throw Throwables.propagate((Throwable)e);
                        }
                    }
                });
                if (isSingleThreaded) {
                    GroupByMergedQueryRunner.this.waitForFutureCompletion(query, future, (IncrementalIndex)indexAccumulatorPair.lhs);
                }
                return future;
            }
        })));
        if (!isSingleThreaded) {
            this.waitForFutureCompletion(query, futures, (IncrementalIndex)indexAccumulatorPair.lhs);
        }
        if (bySegment) {
            return Sequences.simple((Iterable)((Iterable)bySegmentAccumulatorPair.lhs));
        }
        return Sequences.withBaggage((Sequence)Sequences.simple((Iterable)Iterables.transform(((IncrementalIndex)indexAccumulatorPair.lhs).iterableWithPostAggregations(null, query.isDescending()), (Function)new Function<Row, T>(){

            public T apply(Row input) {
                return input;
            }
        })), (Closeable)((Closeable)indexAccumulatorPair.lhs));
    }

    private void waitForFutureCompletion(GroupByQuery query, ListenableFuture<?> future, IncrementalIndex<?> closeOnFailure) {
        try {
            this.queryWatcher.registerQuery(query, future);
            if (QueryContexts.hasTimeout(query)) {
                future.get(QueryContexts.getTimeout(query), TimeUnit.MILLISECONDS);
            } else {
                future.get();
            }
        }
        catch (InterruptedException e) {
            log.warn((Throwable)e, "Query interrupted, cancelling pending results, query id [%s]", new Object[]{query.getId()});
            future.cancel(true);
            closeOnFailure.close();
            throw new QueryInterruptedException(e);
        }
        catch (CancellationException e) {
            closeOnFailure.close();
            throw new QueryInterruptedException(e);
        }
        catch (TimeoutException e) {
            closeOnFailure.close();
            log.info("Query timeout, cancelling pending results for query id [%s]", new Object[]{query.getId()});
            future.cancel(true);
            throw new QueryInterruptedException(e);
        }
        catch (ExecutionException e) {
            closeOnFailure.close();
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }
}

