/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.AsyncQueryRunner;
import org.apache.druid.query.MetricsEmittingQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

@Deprecated
public class IntervalChunkingQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> baseRunner;
    private final QueryToolChest<T, Query<T>> toolChest;
    private final ExecutorService executor;
    private final QueryWatcher queryWatcher;
    private final ServiceEmitter emitter;

    public IntervalChunkingQueryRunner(QueryRunner<T> baseRunner, QueryToolChest<T, Query<T>> toolChest, ExecutorService executor, QueryWatcher queryWatcher, ServiceEmitter emitter) {
        this.baseRunner = baseRunner;
        this.toolChest = toolChest;
        this.executor = executor;
        this.queryWatcher = queryWatcher;
        this.emitter = emitter;
    }

    @Override
    public Sequence<T> run(final QueryPlus<T> queryPlus, final Map<String, Object> responseContext) {
        final Period chunkPeriod = this.getChunkPeriod(queryPlus.getQuery());
        if (DateTimes.EPOCH.plus((ReadablePeriod)chunkPeriod).getMillis() == DateTimes.EPOCH.getMillis()) {
            return this.baseRunner.run(queryPlus, responseContext);
        }
        ArrayList chunkIntervals = Lists.newArrayList((Iterable)FunctionalIterable.create(queryPlus.getQuery().getIntervals()).transformCat((Function)new Function<Interval, Iterable<Interval>>(){

            public Iterable<Interval> apply(Interval input) {
                return IntervalChunkingQueryRunner.splitInterval(input, chunkPeriod);
            }
        }));
        if (chunkIntervals.size() <= 1) {
            return this.baseRunner.run(queryPlus, responseContext);
        }
        return Sequences.concat((Iterable)Lists.newArrayList((Iterable)FunctionalIterable.create((Iterable)chunkIntervals).transform(new Function<Interval, Sequence<T>>(){

            public Sequence<T> apply(Interval singleInterval) {
                return new AsyncQueryRunner(IntervalChunkingQueryRunner.this.toolChest.mergeResults(new MetricsEmittingQueryRunner(IntervalChunkingQueryRunner.this.emitter, IntervalChunkingQueryRunner.this.toolChest, IntervalChunkingQueryRunner.this.baseRunner, QueryMetrics::reportIntervalChunkTime, queryMetrics -> queryMetrics.chunkInterval(singleInterval)).withWaitMeasuredFromNow()), IntervalChunkingQueryRunner.this.executor, IntervalChunkingQueryRunner.this.queryWatcher).run(queryPlus.withQuerySegmentSpec(new MultipleIntervalSegmentSpec(Collections.singletonList(singleInterval))), responseContext);
            }
        })));
    }

    private static Iterable<Interval> splitInterval(Interval interval, Period period) {
        if (interval.getEndMillis() == interval.getStartMillis()) {
            return Collections.singletonList(interval);
        }
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        Iterator timestamps = new PeriodGranularity(period, null, null).getIterable(interval).iterator();
        DateTime start = DateTimes.max((DateTime)((Interval)timestamps.next()).getStart(), (DateTime)interval.getStart());
        while (timestamps.hasNext()) {
            DateTime end = ((Interval)timestamps.next()).getStart();
            intervals.add(new Interval((ReadableInstant)start, (ReadableInstant)end));
            start = end;
        }
        if (start.compareTo((ReadableInstant)interval.getEnd()) < 0) {
            intervals.add(new Interval((ReadableInstant)start, (ReadableInstant)interval.getEnd()));
        }
        return intervals;
    }

    private Period getChunkPeriod(Query<T> query) {
        String p = QueryContexts.getChunkPeriod(query);
        return Period.parse((String)p);
    }
}

