/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Map;
import org.apache.druid.java.util.common.guava.MergeSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.UnionDataSource;

public class UnionQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> baseRunner;

    public UnionQueryRunner(QueryRunner<T> baseRunner) {
        this.baseRunner = baseRunner;
    }

    @Override
    public Sequence<T> run(final QueryPlus<T> queryPlus, final Map<String, Object> responseContext) {
        final Query<T> query = queryPlus.getQuery();
        DataSource dataSource = query.getDataSource();
        if (dataSource instanceof UnionDataSource) {
            return new MergeSequence(query.getResultOrdering(), Sequences.simple((Iterable)Lists.transform(((UnionDataSource)dataSource).getDataSources(), (Function)new Function<DataSource, Sequence<T>>(){

                public Sequence<T> apply(DataSource singleSource) {
                    return UnionQueryRunner.this.baseRunner.run(queryPlus.withQuery(query.withDataSource(singleSource)), responseContext);
                }
            })));
        }
        return this.baseRunner.run(queryPlus, responseContext);
    }
}

