/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.NullableAggregateCombiner;
import org.apache.druid.query.aggregation.NullableAggregator;
import org.apache.druid.query.aggregation.NullableBufferAggregator;
import org.apache.druid.segment.BaseNullableColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;

public abstract class NullableAggregatorFactory<T extends BaseNullableColumnValueSelector>
extends AggregatorFactory {
    @Override
    public final Aggregator factorize(ColumnSelectorFactory metricFactory) {
        T selector = this.selector(metricFactory);
        Aggregator aggregator = this.factorize(metricFactory, selector);
        return NullHandling.replaceWithDefault() ? aggregator : new NullableAggregator(aggregator, (BaseNullableColumnValueSelector)selector);
    }

    @Override
    public final BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        T selector = this.selector(metricFactory);
        BufferAggregator aggregator = this.factorizeBuffered(metricFactory, selector);
        return NullHandling.replaceWithDefault() ? aggregator : new NullableBufferAggregator(aggregator, (BaseNullableColumnValueSelector)selector);
    }

    @Override
    public final AggregateCombiner makeNullableAggregateCombiner() {
        AggregateCombiner combiner = this.makeAggregateCombiner();
        return NullHandling.replaceWithDefault() ? combiner : new NullableAggregateCombiner(combiner);
    }

    @Override
    public final int getMaxIntermediateSizeWithNulls() {
        return this.getMaxIntermediateSize() + (NullHandling.replaceWithDefault() ? 0 : 1);
    }

    protected abstract T selector(ColumnSelectorFactory var1);

    protected abstract Aggregator factorize(ColumnSelectorFactory var1, T var2);

    protected abstract BufferAggregator factorizeBuffered(ColumnSelectorFactory var1, T var2);
}

