/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.druid.query.aggregation.AggregatorUtil;
import org.apache.druid.query.aggregation.DoubleSumAggregator;
import org.apache.druid.query.aggregation.NullableAggregatorFactory;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnHolder;

public abstract class SimpleDoubleAggregatorFactory
extends NullableAggregatorFactory<BaseDoubleColumnValueSelector> {
    protected final String name;
    @Nullable
    protected final String fieldName;
    @Nullable
    protected final String expression;
    protected final ExprMacroTable macroTable;
    protected final boolean storeDoubleAsFloat;

    public SimpleDoubleAggregatorFactory(ExprMacroTable macroTable, String name, @Nullable String fieldName, @Nullable String expression) {
        this.macroTable = macroTable;
        this.name = name;
        this.fieldName = fieldName;
        this.expression = expression;
        this.storeDoubleAsFloat = ColumnHolder.storeDoubleAsFloat();
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkArgument((boolean)(fieldName == null ^ expression == null), (Object)"Must have a valid, non-null fieldName or expression");
    }

    protected BaseDoubleColumnValueSelector getDoubleColumnSelector(ColumnSelectorFactory metricFactory, double nullValue) {
        return AggregatorUtil.makeColumnValueSelectorWithDoubleDefault(metricFactory, this.macroTable, this.fieldName, this.expression, nullValue);
    }

    @Override
    public Object deserialize(Object object) {
        if (object instanceof String) {
            return Double.parseDouble((String)object);
        }
        return object;
    }

    @Override
    public String getTypeName() {
        if (this.storeDoubleAsFloat) {
            return "float";
        }
        return "double";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 8;
    }

    @Override
    public Comparator getComparator() {
        return DoubleSumAggregator.COMPARATOR;
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object;
    }

    @Override
    public List<String> requiredFields() {
        return this.fieldName != null ? Collections.singletonList(this.fieldName) : Parser.findRequiredBindings((Expr)Parser.parse((String)this.expression, (ExprMacroTable)this.macroTable));
    }

    @Override
    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && this.getClass() == other.getClass()) {
            return this.getCombiningFactory();
        }
        throw new AggregatorFactoryNotMergeableException(this, other);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.expression, this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleDoubleAggregatorFactory that = (SimpleDoubleAggregatorFactory)o;
        if (!Objects.equals(this.fieldName, that.fieldName)) {
            return false;
        }
        if (!Objects.equals(this.expression, that.expression)) {
            return false;
        }
        return Objects.equals(this.name, that.name);
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Nullable
    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @Nullable
    @JsonProperty
    public String getExpression() {
        return this.expression;
    }
}

