/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import org.apache.druid.collections.SerializablePair;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;

public class DoubleFirstAggregator
implements Aggregator {
    private final BaseDoubleColumnValueSelector valueSelector;
    private final BaseLongColumnValueSelector timeSelector;
    protected long firstTime;
    protected double firstValue;

    public DoubleFirstAggregator(BaseLongColumnValueSelector timeSelector, BaseDoubleColumnValueSelector valueSelector) {
        this.valueSelector = valueSelector;
        this.timeSelector = timeSelector;
        this.firstTime = Long.MAX_VALUE;
        this.firstValue = 0.0;
    }

    @Override
    public void aggregate() {
        long time = this.timeSelector.getLong();
        if (time < this.firstTime) {
            this.firstTime = time;
            this.firstValue = this.valueSelector.getDouble();
        }
    }

    @Override
    public Object get() {
        return new SerializablePair((Object)this.firstTime, (Object)this.firstValue);
    }

    @Override
    public float getFloat() {
        return (float)this.firstValue;
    }

    @Override
    public double getDouble() {
        return this.firstValue;
    }

    @Override
    public long getLong() {
        return (long)this.firstValue;
    }

    @Override
    public void close() {
    }
}

