/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;

public class RegexpExtractExprMacro
implements ExprMacroTable.ExprMacro {
    public String name() {
        return "regexp_extract";
    }

    public Expr apply(List<Expr> args) {
        Expr indexExpr;
        if (args.size() < 2 || args.size() > 3) {
            throw new IAE("Function[%s] must have 2 to 3 arguments", new Object[]{this.name()});
        }
        final Expr arg = args.get(0);
        Expr patternExpr = args.get(1);
        Expr expr = indexExpr = args.size() > 2 ? args.get(2) : null;
        if (!patternExpr.isLiteral() || indexExpr != null && !indexExpr.isLiteral()) {
            throw new IAE("Function[%s] pattern and index must be literals", new Object[]{this.name()});
        }
        final Pattern pattern = Pattern.compile(String.valueOf(patternExpr.getLiteralValue()));
        final int index = indexExpr == null ? 0 : ((Number)indexExpr.getLiteralValue()).intValue();
        class RegexpExtractExpr
        implements Expr {
            RegexpExtractExpr() {
            }

            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                String s = arg.eval(bindings).asString();
                Matcher matcher = pattern.matcher(NullHandling.nullToEmptyIfNeeded((String)s));
                String retVal = matcher.find() ? matcher.group(index) : null;
                return ExprEval.of((String)NullHandling.emptyToNullIfNeeded((String)retVal));
            }

            public void visit(Expr.Visitor visitor) {
                arg.visit(visitor);
                visitor.visit((Expr)this);
            }
        }
        return new RegexpExtractExpr();
    }
}

