/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.RangeSet;
import com.google.common.collect.Sets;
import com.google.common.primitives.Longs;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.ordering.StringComparators;
import org.joda.time.Interval;

public class IntervalDimFilter
implements DimFilter {
    private final List<Interval> intervals;
    private final List<Pair<Long, Long>> intervalLongs;
    private final String dimension;
    private final ExtractionFn extractionFn;
    private final OrDimFilter convertedFilter;

    @JsonCreator
    public IntervalDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="intervals") List<Interval> intervals, @JsonProperty(value="extractionFn") ExtractionFn extractionFn) {
        Preconditions.checkNotNull((Object)dimension, (Object)"dimension can not be null");
        Preconditions.checkNotNull(intervals, (Object)"intervals can not be null");
        Preconditions.checkArgument((intervals.size() > 0 ? 1 : 0) != 0, (Object)"must specify at least one interval");
        this.dimension = dimension;
        this.intervals = Collections.unmodifiableList(JodaUtils.condenseIntervals(intervals));
        this.extractionFn = extractionFn;
        this.intervalLongs = this.makeIntervalLongs();
        this.convertedFilter = new OrDimFilter(this.makeBoundDimFilters());
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public List<Interval> getIntervals() {
        return this.intervals;
    }

    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8((String)this.dimension);
        byte[] extractionFnBytes = this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey();
        int intervalsBytesSize = this.intervalLongs.size() * 8 * 2 + this.intervalLongs.size();
        ByteBuffer filterCacheKey = ByteBuffer.allocate(3 + dimensionBytes.length + intervalsBytesSize + extractionFnBytes.length).put((byte)11).put(dimensionBytes).put((byte)-1).put(extractionFnBytes).put((byte)-1);
        for (Pair<Long, Long> interval : this.intervalLongs) {
            filterCacheKey.put(Longs.toByteArray((long)((Long)interval.lhs))).put(Longs.toByteArray((long)((Long)interval.rhs))).put((byte)-1);
        }
        return filterCacheKey.array();
    }

    @Override
    public DimFilter optimize() {
        return this;
    }

    @Override
    public Filter toFilter() {
        return this.convertedFilter.toFilter();
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        return this.convertedFilter.getDimensionRangeSet(dimension);
    }

    @Override
    public HashSet<String> getRequiredColumns() {
        return Sets.newHashSet((Object[])new String[]{this.dimension});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalDimFilter that = (IntervalDimFilter)o;
        if (!this.getIntervals().equals(that.getIntervals())) {
            return false;
        }
        if (!this.getDimension().equals(that.getDimension())) {
            return false;
        }
        return this.getExtractionFn() != null ? this.getExtractionFn().equals(that.getExtractionFn()) : that.getExtractionFn() == null;
    }

    public int hashCode() {
        int result = this.getIntervals().hashCode();
        result = 31 * result + this.getDimension().hashCode();
        result = 31 * result + (this.getExtractionFn() != null ? this.getExtractionFn().hashCode() : 0);
        return result;
    }

    private List<Pair<Long, Long>> makeIntervalLongs() {
        ArrayList<Pair<Long, Long>> intervalLongs = new ArrayList<Pair<Long, Long>>();
        for (Interval interval : this.intervals) {
            intervalLongs.add((Pair<Long, Long>)new Pair((Object)interval.getStartMillis(), (Object)interval.getEndMillis()));
        }
        return intervalLongs;
    }

    private List<DimFilter> makeBoundDimFilters() {
        ArrayList<DimFilter> boundDimFilters = new ArrayList<DimFilter>();
        for (Pair<Long, Long> interval : this.intervalLongs) {
            BoundDimFilter boundDimFilter = new BoundDimFilter(this.dimension, String.valueOf(interval.lhs), String.valueOf(interval.rhs), false, true, null, this.extractionFn, StringComparators.NUMERIC);
            boundDimFilters.add(boundDimFilter);
        }
        return boundDimFilters;
    }
}

