/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.RangeSet;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Chars;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.filter.LikeFilter;

public class LikeDimFilter
implements DimFilter {
    private static final Pattern DEFINITELY_FINE = Pattern.compile("[\\w\\d\\s-]");
    private static final String WILDCARD = ".*";
    private final String dimension;
    private final String pattern;
    private final Character escapeChar;
    private final ExtractionFn extractionFn;
    private final LikeMatcher likeMatcher;

    @JsonCreator
    public LikeDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="pattern") String pattern, @JsonProperty(value="escape") String escape, @JsonProperty(value="extractionFn") ExtractionFn extractionFn) {
        this.dimension = (String)Preconditions.checkNotNull((Object)dimension, (Object)"dimension");
        this.pattern = (String)Preconditions.checkNotNull((Object)pattern, (Object)"pattern");
        this.extractionFn = extractionFn;
        if (escape != null && escape.length() != 1) {
            throw new IllegalArgumentException("Escape must be null or a single character");
        }
        this.escapeChar = escape == null || escape.isEmpty() ? null : Character.valueOf(escape.charAt(0));
        this.likeMatcher = LikeMatcher.from(pattern, this.escapeChar);
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public String getPattern() {
        return this.pattern;
    }

    @JsonProperty
    public String getEscape() {
        return this.escapeChar != null ? this.escapeChar.toString() : null;
    }

    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8((String)this.dimension);
        byte[] patternBytes = StringUtils.toUtf8((String)this.pattern);
        byte[] escapeBytes = this.escapeChar == null ? new byte[]{} : Chars.toByteArray((char)this.escapeChar.charValue());
        byte[] extractionFnBytes = this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey();
        int sz = 4 + dimensionBytes.length + patternBytes.length + escapeBytes.length + extractionFnBytes.length;
        return ByteBuffer.allocate(sz).put((byte)12).put(dimensionBytes).put((byte)-1).put(patternBytes).put((byte)-1).put(escapeBytes).put((byte)-1).put(extractionFnBytes).array();
    }

    @Override
    public DimFilter optimize() {
        return this;
    }

    @Override
    public Filter toFilter() {
        return new LikeFilter(this.dimension, this.extractionFn, this.likeMatcher);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        return null;
    }

    @Override
    public HashSet<String> getRequiredColumns() {
        return Sets.newHashSet((Object[])new String[]{this.dimension});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LikeDimFilter that = (LikeDimFilter)o;
        if (this.dimension != null ? !this.dimension.equals(that.dimension) : that.dimension != null) {
            return false;
        }
        if (this.pattern != null ? !this.pattern.equals(that.pattern) : that.pattern != null) {
            return false;
        }
        if (this.escapeChar != null ? !this.escapeChar.equals(that.escapeChar) : that.escapeChar != null) {
            return false;
        }
        return this.extractionFn != null ? this.extractionFn.equals(that.extractionFn) : that.extractionFn == null;
    }

    public int hashCode() {
        int result = this.dimension != null ? this.dimension.hashCode() : 0;
        result = 31 * result + (this.pattern != null ? this.pattern.hashCode() : 0);
        result = 31 * result + (this.escapeChar != null ? this.escapeChar.hashCode() : 0);
        result = 31 * result + (this.extractionFn != null ? this.extractionFn.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.extractionFn != null) {
            builder.append(this.extractionFn).append("(");
        }
        builder.append(this.dimension);
        if (this.extractionFn != null) {
            builder.append(")");
        }
        builder.append(" LIKE '").append(this.pattern).append("'");
        if (this.escapeChar != null) {
            builder.append(" ESCAPE '").append(this.escapeChar).append("'");
        }
        return builder.toString();
    }

    public static class LikeMatcher {
        private final SuffixMatch suffixMatch;
        private final String prefix;
        private final Pattern pattern;

        private LikeMatcher(SuffixMatch suffixMatch, String prefix, Pattern pattern) {
            this.suffixMatch = (SuffixMatch)((Object)Preconditions.checkNotNull((Object)((Object)suffixMatch), (Object)"suffixMatch"));
            this.prefix = NullHandling.nullToEmptyIfNeeded((String)prefix);
            this.pattern = (Pattern)Preconditions.checkNotNull((Object)pattern, (Object)"pattern");
        }

        public static LikeMatcher from(String likePattern, @Nullable Character escapeChar) {
            StringBuilder prefix = new StringBuilder();
            StringBuilder regex = new StringBuilder();
            boolean escaping = false;
            boolean inPrefix = true;
            SuffixMatch suffixMatch = SuffixMatch.MATCH_EMPTY;
            for (int i = 0; i < likePattern.length(); ++i) {
                char c = likePattern.charAt(i);
                if (escapeChar != null && c == escapeChar.charValue() && !escaping) {
                    escaping = true;
                    continue;
                }
                if (c == '%' && !escaping) {
                    inPrefix = false;
                    if (suffixMatch == SuffixMatch.MATCH_EMPTY) {
                        suffixMatch = SuffixMatch.MATCH_ANY;
                    }
                    regex.append(LikeDimFilter.WILDCARD);
                    continue;
                }
                if (c == '_' && !escaping) {
                    inPrefix = false;
                    suffixMatch = SuffixMatch.MATCH_PATTERN;
                    regex.append(".");
                    continue;
                }
                if (inPrefix) {
                    prefix.append(c);
                } else {
                    suffixMatch = SuffixMatch.MATCH_PATTERN;
                }
                LikeMatcher.addPatternCharacter(regex, c);
                escaping = false;
            }
            return new LikeMatcher(suffixMatch, prefix.toString(), Pattern.compile(regex.toString()));
        }

        private static void addPatternCharacter(StringBuilder patternBuilder, char c) {
            if (DEFINITELY_FINE.matcher(String.valueOf(c)).matches()) {
                patternBuilder.append(c);
            } else {
                patternBuilder.append("\\u").append(BaseEncoding.base16().encode(Chars.toByteArray((char)c)));
            }
        }

        public boolean matches(@Nullable String s) {
            String val = NullHandling.nullToEmptyIfNeeded((String)s);
            return val != null && this.pattern.matcher(val).matches();
        }

        public boolean matchesSuffixOnly(Indexed<String> strings, int i) {
            if (this.suffixMatch == SuffixMatch.MATCH_ANY) {
                return true;
            }
            if (this.suffixMatch == SuffixMatch.MATCH_EMPTY) {
                String s = strings.get(i);
                return s == null ? this.matches(null) : s.length() == this.prefix.length();
            }
            String s = strings.get(i);
            return this.matches(s);
        }

        public DruidPredicateFactory predicateFactory(final ExtractionFn extractionFn) {
            return new DruidPredicateFactory(){

                @Override
                public Predicate<String> makeStringPredicate() {
                    if (extractionFn != null) {
                        return input -> this.matches(extractionFn.apply((String)input));
                    }
                    return input -> this.matches((String)input);
                }

                @Override
                public DruidLongPredicate makeLongPredicate() {
                    if (extractionFn != null) {
                        return input -> this.matches(extractionFn.apply(input));
                    }
                    return input -> this.matches(String.valueOf(input));
                }

                @Override
                public DruidFloatPredicate makeFloatPredicate() {
                    if (extractionFn != null) {
                        return input -> this.matches(extractionFn.apply(Float.valueOf(input)));
                    }
                    return input -> this.matches(String.valueOf(input));
                }

                @Override
                public DruidDoublePredicate makeDoublePredicate() {
                    if (extractionFn != null) {
                        return input -> this.matches(extractionFn.apply(input));
                    }
                    return input -> this.matches(String.valueOf(input));
                }
            };
        }

        public String getPrefix() {
            return this.prefix;
        }

        public SuffixMatch getSuffixMatch() {
            return this.suffixMatch;
        }

        public static enum SuffixMatch {
            MATCH_ANY,
            MATCH_EMPTY,
            MATCH_PATTERN;

        }
    }
}

