/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.RangeSet;
import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.util.HashSet;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.search.SearchQuerySpec;
import org.apache.druid.segment.filter.SearchQueryFilter;

public class SearchQueryDimFilter
implements DimFilter {
    private final String dimension;
    private final SearchQuerySpec query;
    private final ExtractionFn extractionFn;

    public SearchQueryDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="query") SearchQuerySpec query, @JsonProperty(value="extractionFn") ExtractionFn extractionFn) {
        Preconditions.checkArgument((dimension != null ? 1 : 0) != 0, (Object)"dimension must not be null");
        Preconditions.checkArgument((query != null ? 1 : 0) != 0, (Object)"query must not be null");
        this.dimension = dimension;
        this.query = query;
        this.extractionFn = extractionFn;
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public SearchQuerySpec getQuery() {
        return this.query;
    }

    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8((String)this.dimension);
        byte[] queryBytes = this.query.getCacheKey();
        byte[] extractionFnBytes = this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey();
        return ByteBuffer.allocate(3 + dimensionBytes.length + queryBytes.length + extractionFnBytes.length).put((byte)6).put(dimensionBytes).put((byte)-1).put(queryBytes).put((byte)-1).put(extractionFnBytes).array();
    }

    @Override
    public DimFilter optimize() {
        return this;
    }

    @Override
    public Filter toFilter() {
        return new SearchQueryFilter(this.dimension, this.query, this.extractionFn);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        return null;
    }

    @Override
    public HashSet<String> getRequiredColumns() {
        return Sets.newHashSet((Object[])new String[]{this.dimension});
    }

    public String toString() {
        return "SearchQueryDimFilter{dimension='" + this.dimension + '\'' + ", query=" + this.query + ", extractionFn='" + this.extractionFn + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchQueryDimFilter)) {
            return false;
        }
        SearchQueryDimFilter that = (SearchQueryDimFilter)o;
        if (!this.dimension.equals(that.dimension)) {
            return false;
        }
        if (!this.query.equals(that.query)) {
            return false;
        }
        return this.extractionFn != null ? this.extractionFn.equals(that.extractionFn) : that.extractionFn == null;
    }

    public int hashCode() {
        int result = this.dimension.hashCode();
        result = 31 * result + this.query.hashCode();
        result = 31 * result + (this.extractionFn != null ? this.extractionFn.hashCode() : 0);
        return result;
    }
}

