/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.Row;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.LongColumnSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.RangeIndexedInts;

public class RowBasedColumnSelectorFactory
implements ColumnSelectorFactory {
    private final Supplier<? extends Row> row;
    private final Map<String, ValueType> rowSignature;

    private RowBasedColumnSelectorFactory(Supplier<? extends Row> row, @Nullable Map<String, ValueType> rowSignature) {
        this.row = row;
        this.rowSignature = rowSignature != null ? rowSignature : ImmutableMap.of();
    }

    public static RowBasedColumnSelectorFactory create(Supplier<? extends Row> row, @Nullable Map<String, ValueType> rowSignature) {
        return new RowBasedColumnSelectorFactory(row, rowSignature);
    }

    public static RowBasedColumnSelectorFactory create(ThreadLocal<? extends Row> row, @Nullable Map<String, ValueType> rowSignature) {
        return new RowBasedColumnSelectorFactory((Supplier<? extends Row>)((Supplier)row::get), rowSignature);
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        return dimensionSpec.decorate(this.makeDimensionSelectorUndecorated(dimensionSpec));
    }

    private DimensionSelector makeDimensionSelectorUndecorated(DimensionSpec dimensionSpec) {
        final String dimension = dimensionSpec.getDimension();
        final ExtractionFn extractionFn = dimensionSpec.getExtractionFn();
        if ("__time".equals(dimensionSpec.getDimension())) {
            if (extractionFn == null) {
                throw new UnsupportedOperationException("time dimension must provide an extraction function");
            }
            return new BaseSingleValueDimensionSelector(){

                @Override
                protected String getValue() {
                    return extractionFn.apply(((Row)RowBasedColumnSelectorFactory.this.row.get()).getTimestampFromEpoch());
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                    inspector.visit("extractionFn", extractionFn);
                }
            };
        }
        return new DimensionSelector(){
            private final RangeIndexedInts indexedInts = new RangeIndexedInts();

            @Override
            public IndexedInts getRow() {
                List dimensionValues = ((Row)RowBasedColumnSelectorFactory.this.row.get()).getDimension(dimension);
                this.indexedInts.setSize(dimensionValues != null ? dimensionValues.size() : 0);
                return this.indexedInts;
            }

            @Override
            public ValueMatcher makeValueMatcher(final @Nullable String value) {
                if (extractionFn == null) {
                    return new ValueMatcher(){

                        @Override
                        public boolean matches() {
                            List dimensionValues = ((Row)RowBasedColumnSelectorFactory.this.row.get()).getDimension(dimension);
                            if (dimensionValues == null || dimensionValues.isEmpty()) {
                                return value == null;
                            }
                            for (String dimensionValue : dimensionValues) {
                                if (!Objects.equals(NullHandling.emptyToNullIfNeeded((String)dimensionValue), value)) continue;
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                            inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                        }
                    };
                }
                return new ValueMatcher(){

                    @Override
                    public boolean matches() {
                        List dimensionValues = ((Row)RowBasedColumnSelectorFactory.this.row.get()).getDimension(dimension);
                        if (dimensionValues == null || dimensionValues.isEmpty()) {
                            return value == null;
                        }
                        for (String dimensionValue : dimensionValues) {
                            if (!Objects.equals(extractionFn.apply(NullHandling.emptyToNullIfNeeded((String)dimensionValue)), value)) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                        inspector.visit("extractionFn", extractionFn);
                    }
                };
            }

            @Override
            public ValueMatcher makeValueMatcher(final Predicate<String> predicate) {
                final boolean matchNull = predicate.apply(null);
                if (extractionFn == null) {
                    return new ValueMatcher(){

                        @Override
                        public boolean matches() {
                            List dimensionValues = ((Row)RowBasedColumnSelectorFactory.this.row.get()).getDimension(dimension);
                            if (dimensionValues == null || dimensionValues.isEmpty()) {
                                return matchNull;
                            }
                            for (String dimensionValue : dimensionValues) {
                                if (!predicate.apply((Object)NullHandling.emptyToNullIfNeeded((String)dimensionValue))) continue;
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                            inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                            inspector.visit("predicate", predicate);
                        }
                    };
                }
                return new ValueMatcher(){

                    @Override
                    public boolean matches() {
                        List dimensionValues = ((Row)RowBasedColumnSelectorFactory.this.row.get()).getDimension(dimension);
                        if (dimensionValues == null || dimensionValues.isEmpty()) {
                            return matchNull;
                        }
                        for (String dimensionValue : dimensionValues) {
                            if (!predicate.apply((Object)extractionFn.apply(NullHandling.emptyToNullIfNeeded((String)dimensionValue)))) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                        inspector.visit("predicate", predicate);
                    }
                };
            }

            @Override
            public int getValueCardinality() {
                return -1;
            }

            @Override
            public String lookupName(int id) {
                String value = NullHandling.emptyToNullIfNeeded((String)((String)((Row)RowBasedColumnSelectorFactory.this.row.get()).getDimension(dimension).get(id)));
                return extractionFn == null ? value : extractionFn.apply(value);
            }

            @Override
            public boolean nameLookupPossibleInAdvance() {
                return false;
            }

            @Override
            @Nullable
            public IdLookup idLookup() {
                return null;
            }

            @Override
            @Nullable
            public Object getObject() {
                List dimensionValues = ((Row)RowBasedColumnSelectorFactory.this.row.get()).getDimension(dimension);
                if (dimensionValues == null) {
                    return null;
                }
                if (dimensionValues.size() == 1) {
                    return dimensionValues.get(0);
                }
                return dimensionValues;
            }

            @Override
            public Class classOfObject() {
                return Object.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                inspector.visit("extractionFn", extractionFn);
            }
        };
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(final String columnName) {
        if (columnName.equals("__time")) {
            class TimeLongColumnSelector
            implements LongColumnSelector {
                TimeLongColumnSelector() {
                }

                @Override
                public long getLong() {
                    return ((Row)RowBasedColumnSelectorFactory.this.row.get()).getTimestampFromEpoch();
                }

                @Override
                public boolean isNull() {
                    return false;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
                }
            }
            return new TimeLongColumnSelector();
        }
        return new ColumnValueSelector(){

            @Override
            public boolean isNull() {
                return ((Row)RowBasedColumnSelectorFactory.this.row.get()).getRaw(columnName) == null;
            }

            @Override
            public double getDouble() {
                Number metric = ((Row)RowBasedColumnSelectorFactory.this.row.get()).getMetric(columnName);
                assert (NullHandling.replaceWithDefault() || metric != null);
                return DimensionHandlerUtils.nullToZero(metric).doubleValue();
            }

            @Override
            public float getFloat() {
                Number metric = ((Row)RowBasedColumnSelectorFactory.this.row.get()).getMetric(columnName);
                assert (NullHandling.replaceWithDefault() || metric != null);
                return DimensionHandlerUtils.nullToZero(metric).floatValue();
            }

            @Override
            public long getLong() {
                Number metric = ((Row)RowBasedColumnSelectorFactory.this.row.get()).getMetric(columnName);
                assert (NullHandling.replaceWithDefault() || metric != null);
                return DimensionHandlerUtils.nullToZero(metric).longValue();
            }

            @Override
            @Nullable
            public Object getObject() {
                return ((Row)RowBasedColumnSelectorFactory.this.row.get()).getRaw(columnName);
            }

            @Override
            public Class classOfObject() {
                return Object.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("row", RowBasedColumnSelectorFactory.this.row);
            }
        };
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        if ("__time".equals(columnName)) {
            return new ColumnCapabilitiesImpl().setType(ValueType.LONG);
        }
        ValueType valueType = this.rowSignature.get(columnName);
        return valueType != null ? new ColumnCapabilitiesImpl().setType(valueType) : null;
    }
}

