/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.google.common.base.Supplier;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.groupby.epinephelinae.AbstractBufferHashGrouper;
import org.apache.druid.query.groupby.epinephelinae.ByteBufferHashTable;
import org.apache.druid.query.groupby.epinephelinae.ByteBufferIntList;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.segment.ColumnSelectorFactory;

public class BufferHashGrouper<KeyType>
extends AbstractBufferHashGrouper<KeyType> {
    private static final int MIN_INITIAL_BUCKETS = 4;
    private static final int DEFAULT_INITIAL_BUCKETS = 1024;
    private static final float DEFAULT_MAX_LOAD_FACTOR = 0.7f;
    private final AggregatorFactory[] aggregatorFactories;
    private ByteBuffer buffer;
    private boolean initialized = false;
    private final boolean useDefaultSorting;
    private ByteBuffer offsetListBuffer;
    private ByteBufferIntList offsetList;

    public BufferHashGrouper(Supplier<ByteBuffer> bufferSupplier, Grouper.KeySerde<KeyType> keySerde, ColumnSelectorFactory columnSelectorFactory, AggregatorFactory[] aggregatorFactories, int bufferGrouperMaxSize, float maxLoadFactor, int initialBuckets, boolean useDefaultSorting) {
        super(bufferSupplier, keySerde, aggregatorFactories, bufferGrouperMaxSize);
        this.aggregatorFactories = aggregatorFactories;
        this.maxLoadFactor = maxLoadFactor > 0.0f ? maxLoadFactor : 0.7f;
        int n = this.initialBuckets = initialBuckets > 0 ? Math.max(4, initialBuckets) : 1024;
        if (this.maxLoadFactor >= 1.0f) {
            throw new IAE("Invalid maxLoadFactor[%f], must be < 1.0", new Object[]{Float.valueOf(maxLoadFactor)});
        }
        int offset = 4 + this.keySize;
        for (int i = 0; i < aggregatorFactories.length; ++i) {
            this.aggregators[i] = aggregatorFactories[i].factorizeBuffered(columnSelectorFactory);
            this.aggregatorOffsets[i] = offset;
            offset += aggregatorFactories[i].getMaxIntermediateSizeWithNulls();
        }
        this.bucketSize = offset;
        this.useDefaultSorting = useDefaultSorting;
    }

    @Override
    public void init() {
        if (!this.initialized) {
            this.buffer = (ByteBuffer)this.bufferSupplier.get();
            int hashTableSize = ByteBufferHashTable.calculateTableArenaSizeWithPerBucketAdditionalSize(this.buffer.capacity(), this.bucketSize, 4);
            this.hashTableBuffer = this.buffer.duplicate();
            this.hashTableBuffer.position(0);
            this.hashTableBuffer.limit(hashTableSize);
            this.hashTableBuffer = this.hashTableBuffer.slice();
            this.offsetListBuffer = this.buffer.duplicate();
            this.offsetListBuffer.position(hashTableSize);
            this.offsetListBuffer.limit(this.buffer.capacity());
            this.offsetListBuffer = this.offsetListBuffer.slice();
            this.offsetList = new ByteBufferIntList(this.offsetListBuffer, this.offsetListBuffer.capacity() / 4);
            this.hashTable = new ByteBufferHashTable(this.maxLoadFactor, this.initialBuckets, this.bucketSize, this.hashTableBuffer, this.keySize, this.bufferGrouperMaxSize, new BufferGrouperBucketUpdateHandler());
            this.reset();
            this.initialized = true;
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void newBucketHook(int bucketOffset) {
    }

    @Override
    public boolean canSkipAggregate(boolean bucketWasUsed, int bucketOffset) {
        return false;
    }

    @Override
    public void afterAggregateHook(int bucketOffset) {
    }

    @Override
    public void reset() {
        this.offsetList.reset();
        this.hashTable.reset();
        this.keySerde.reset();
    }

    @Override
    public CloseableIterator<Grouper.Entry<KeyType>> iterator(boolean sorted) {
        if (!this.initialized) {
            return CloseableIterators.withEmptyBaggage(Collections.emptyIterator());
        }
        if (sorted) {
            final AbstractList<Integer> wrappedOffsets = new AbstractList<Integer>(){

                @Override
                public Integer get(int index) {
                    return BufferHashGrouper.this.offsetList.get(index);
                }

                @Override
                public Integer set(int index, Integer element) {
                    Integer oldValue = this.get(index);
                    BufferHashGrouper.this.offsetList.set(index, element);
                    return oldValue;
                }

                @Override
                public int size() {
                    return BufferHashGrouper.this.hashTable.getSize();
                }
            };
            final Grouper.BufferComparator comparator = this.useDefaultSorting ? this.keySerde.bufferComparator() : this.keySerde.bufferComparatorWithAggregators(this.aggregatorFactories, this.aggregatorOffsets);
            Collections.sort(wrappedOffsets, new Comparator<Integer>(){

                @Override
                public int compare(Integer lhs, Integer rhs) {
                    ByteBuffer tableBuffer = BufferHashGrouper.this.hashTable.getTableBuffer();
                    return comparator.compare(tableBuffer, tableBuffer, lhs + 4, rhs + 4);
                }
            });
            return new CloseableIterator<Grouper.Entry<KeyType>>(){
                int curr = 0;
                final int size = BufferHashGrouper.this.getSize();

                public boolean hasNext() {
                    return this.curr < this.size;
                }

                public Grouper.Entry<KeyType> next() {
                    if (this.curr >= this.size) {
                        throw new NoSuchElementException();
                    }
                    return BufferHashGrouper.this.bucketEntryForOffset((Integer)wrappedOffsets.get(this.curr++));
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public void close() {
                }
            };
        }
        return new CloseableIterator<Grouper.Entry<KeyType>>(){
            int curr = 0;
            final int size = BufferHashGrouper.this.getSize();

            public boolean hasNext() {
                return this.curr < this.size;
            }

            public Grouper.Entry<KeyType> next() {
                if (this.curr >= this.size) {
                    throw new NoSuchElementException();
                }
                int offset = BufferHashGrouper.this.offsetList.get(this.curr);
                Grouper.Entry entry = BufferHashGrouper.this.bucketEntryForOffset(offset);
                ++this.curr;
                return entry;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void close() {
            }
        };
    }

    private class BufferGrouperBucketUpdateHandler
    implements ByteBufferHashTable.BucketUpdateHandler {
        private BufferGrouperBucketUpdateHandler() {
        }

        @Override
        public void handleNewBucket(int bucketOffset) {
            BufferHashGrouper.this.offsetList.add(bucketOffset);
        }

        @Override
        public void handlePreTableSwap() {
            BufferHashGrouper.this.offsetList.reset();
        }

        @Override
        public void handleBucketMove(int oldBucketOffset, int newBucketOffset, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
            for (int i = 0; i < BufferHashGrouper.this.aggregators.length; ++i) {
                BufferHashGrouper.this.aggregators[i].relocate(oldBucketOffset + BufferHashGrouper.this.aggregatorOffsets[i], newBucketOffset + BufferHashGrouper.this.aggregatorOffsets[i], oldBuffer, newBuffer);
            }
            BufferHashGrouper.this.offsetList.add(newBucketOffset);
        }
    }
}

