/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.column;

import java.nio.ByteBuffer;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorStrategy;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;

public class FloatGroupByColumnSelectorStrategy
implements GroupByColumnSelectorStrategy {
    @Override
    public int getGroupingKeySize() {
        return 4;
    }

    @Override
    public void processValueFromGroupingKey(GroupByColumnSelectorPlus selectorPlus, ByteBuffer key, Map<String, Object> resultMap, int keyBufferPosition) {
        float val = key.getFloat(keyBufferPosition);
        resultMap.put(selectorPlus.getOutputName(), Float.valueOf(val));
    }

    @Override
    public void initColumnValues(ColumnValueSelector selector, int columnIndex, Object[] valuess) {
        valuess[columnIndex] = Float.valueOf(selector.getFloat());
    }

    @Override
    public Object getOnlyValue(ColumnValueSelector selector) {
        return Float.valueOf(selector.getFloat());
    }

    @Override
    public void writeToKeyBuffer(int keyBufferPosition, @Nullable Object obj, ByteBuffer keyBuffer) {
        keyBuffer.putFloat(keyBufferPosition, DimensionHandlerUtils.nullToZero((Float)obj).floatValue());
    }

    @Override
    public void initGroupingKeyColumnValue(int keyBufferPosition, int columnIndex, Object rowObj, ByteBuffer keyBuffer, int[] stack) {
        this.writeToKeyBuffer(keyBufferPosition, rowObj, keyBuffer);
        stack[columnIndex] = 1;
    }

    @Override
    public boolean checkRowIndexAndAddValueToGroupingKey(int keyBufferPosition, Object rowObj, int rowValIdx, ByteBuffer keyBuffer) {
        return false;
    }
}

