/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanResultValue;

public class ScanQueryLimitRowIterator
implements CloseableIterator<ScanResultValue> {
    private Yielder<ScanResultValue> yielder;
    private String resultFormat;
    private long limit;
    private long count = 0L;

    public ScanQueryLimitRowIterator(QueryRunner<ScanResultValue> baseRunner, QueryPlus<ScanResultValue> queryPlus, Map<String, Object> responseContext) {
        ScanQuery query = (ScanQuery)queryPlus.getQuery();
        this.resultFormat = query.getResultFormat();
        this.limit = query.getLimit();
        Sequence<ScanResultValue> baseSequence = baseRunner.run(queryPlus, responseContext);
        this.yielder = baseSequence.toYielder(null, (YieldingAccumulator)new YieldingAccumulator<ScanResultValue, ScanResultValue>(){

            public ScanResultValue accumulate(ScanResultValue accumulated, ScanResultValue in) {
                this.yield();
                return in;
            }
        });
    }

    public boolean hasNext() {
        return !this.yielder.isDone() && this.count < this.limit;
    }

    public ScanResultValue next() {
        ScanResultValue batch = (ScanResultValue)this.yielder.get();
        if ("compactedList".equals(this.resultFormat) || "list".equals(this.resultFormat)) {
            List events = (List)batch.getEvents();
            if ((long)events.size() <= this.limit - this.count) {
                this.count += (long)events.size();
                this.yielder = this.yielder.next(null);
                return batch;
            }
            int left = (int)(this.limit - this.count);
            this.count = this.limit;
            return new ScanResultValue(batch.getSegmentId(), batch.getColumns(), events.subList(0, left));
        }
        throw new UnsupportedOperationException("valueVector is not supported yet");
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        this.yielder.close();
    }
}

