/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.select;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.nary.BinaryFn;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.IntervalChunkingQueryRunnerDecorator;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.Result;
import org.apache.druid.query.ResultGranularTimestampComparator;
import org.apache.druid.query.ResultMergeQueryRunner;
import org.apache.druid.query.aggregation.MetricManipulationFn;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.select.DefaultSelectQueryMetricsFactory;
import org.apache.druid.query.select.EventHolder;
import org.apache.druid.query.select.PagingSpec;
import org.apache.druid.query.select.SelectBinaryFn;
import org.apache.druid.query.select.SelectQuery;
import org.apache.druid.query.select.SelectQueryConfig;
import org.apache.druid.query.select.SelectQueryMetrics;
import org.apache.druid.query.select.SelectQueryMetricsFactory;
import org.apache.druid.query.select.SelectResultValue;
import org.apache.druid.timeline.LogicalSegment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class SelectQueryQueryToolChest
extends QueryToolChest<Result<SelectResultValue>, SelectQuery> {
    private static final byte SELECT_QUERY = 22;
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};
    private static final TypeReference<Result<SelectResultValue>> TYPE_REFERENCE = new TypeReference<Result<SelectResultValue>>(){};
    private final ObjectMapper jsonMapper;
    @Deprecated
    private final IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator;
    private final SelectQueryMetricsFactory queryMetricsFactory;

    public SelectQueryQueryToolChest(ObjectMapper jsonMapper, IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator, Supplier<SelectQueryConfig> configSupplier) {
        this(jsonMapper, intervalChunkingQueryRunnerDecorator, configSupplier, DefaultSelectQueryMetricsFactory.instance());
    }

    @Inject
    public SelectQueryQueryToolChest(ObjectMapper jsonMapper, IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator, Supplier<SelectQueryConfig> configSupplier, SelectQueryMetricsFactory queryMetricsFactory) {
        this.jsonMapper = jsonMapper;
        this.intervalChunkingQueryRunnerDecorator = intervalChunkingQueryRunnerDecorator;
        this.queryMetricsFactory = queryMetricsFactory;
    }

    @Override
    public QueryRunner<Result<SelectResultValue>> mergeResults(QueryRunner<Result<SelectResultValue>> queryRunner) {
        return new ResultMergeQueryRunner<Result<SelectResultValue>>(queryRunner){

            @Override
            protected Ordering<Result<SelectResultValue>> makeOrdering(Query<Result<SelectResultValue>> query) {
                return ResultGranularTimestampComparator.create(((SelectQuery)query).getGranularity(), query.isDescending());
            }

            @Override
            protected BinaryFn<Result<SelectResultValue>, Result<SelectResultValue>, Result<SelectResultValue>> createMergeFn(Query<Result<SelectResultValue>> input) {
                SelectQuery query = (SelectQuery)input;
                return new SelectBinaryFn(query.getGranularity(), query.getPagingSpec(), query.isDescending());
            }
        };
    }

    public SelectQueryMetrics makeMetrics(SelectQuery query) {
        SelectQueryMetrics queryMetrics = this.queryMetricsFactory.makeMetrics(query);
        queryMetrics.query(query);
        return queryMetrics;
    }

    @Override
    public Function<Result<SelectResultValue>, Result<SelectResultValue>> makePreComputeManipulatorFn(SelectQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }

    @Override
    public TypeReference<Result<SelectResultValue>> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy<Result<SelectResultValue>, Object, SelectQuery> getCacheStrategy(final SelectQuery query) {
        return new CacheStrategy<Result<SelectResultValue>, Object, SelectQuery>(){
            private final List<DimensionSpec> dimensionSpecs;
            private final List<String> dimOutputNames;
            {
                this.dimensionSpecs = query.getDimensions() != null ? query.getDimensions() : Collections.emptyList();
                this.dimOutputNames = this.dimensionSpecs.size() > 0 ? Lists.transform(this.dimensionSpecs, DimensionSpec::getOutputName) : Collections.emptyList();
            }

            @Override
            public boolean isCacheable(SelectQuery query2, boolean willMergeRunners) {
                return true;
            }

            @Override
            public byte[] computeCacheKey(SelectQuery query2) {
                DimFilter dimFilter = query2.getDimensionsFilter();
                byte[] filterBytes = dimFilter == null ? new byte[]{} : dimFilter.getCacheKey();
                byte[] granularityBytes = query2.getGranularity().getCacheKey();
                List<Object> dimensionSpecs = query2.getDimensions() != null ? query2.getDimensions() : Collections.emptyList();
                byte[][] dimensionsBytes = new byte[dimensionSpecs.size()][];
                int dimensionsBytesSize = 0;
                int index = 0;
                for (DimensionSpec dimensionSpec : dimensionSpecs) {
                    dimensionsBytes[index] = dimensionSpec.getCacheKey();
                    dimensionsBytesSize += dimensionsBytes[index].length;
                    ++index;
                }
                TreeSet<String> metrics = new TreeSet<String>();
                if (query2.getMetrics() != null) {
                    metrics.addAll(query2.getMetrics());
                }
                byte[][] byArrayArray = new byte[metrics.size()][];
                int metricBytesSize = 0;
                index = 0;
                for (String metric : metrics) {
                    byArrayArray[index] = StringUtils.toUtf8((String)metric);
                    metricBytesSize += byArrayArray[index].length;
                    ++index;
                }
                byte[] virtualColumnsCacheKey = query2.getVirtualColumns().getCacheKey();
                byte isDescendingByte = query2.isDescending() ? (byte)1 : 0;
                ByteBuffer queryCacheKey = ByteBuffer.allocate(2 + granularityBytes.length + filterBytes.length + query2.getPagingSpec().getCacheKey().length + dimensionsBytesSize + metricBytesSize + virtualColumnsCacheKey.length).put((byte)22).put(granularityBytes).put(filterBytes).put(query2.getPagingSpec().getCacheKey()).put(isDescendingByte);
                for (byte[] dimensionsByte : dimensionsBytes) {
                    queryCacheKey.put(dimensionsByte);
                }
                for (byte[] metricByte : byArrayArray) {
                    queryCacheKey.put(metricByte);
                }
                queryCacheKey.put(virtualColumnsCacheKey);
                return queryCacheKey.array();
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<Result<SelectResultValue>, Object> prepareForCache(boolean isResultLevelCache) {
                return new Function<Result<SelectResultValue>, Object>(){

                    public Object apply(Result<SelectResultValue> input) {
                        if (!dimOutputNames.isEmpty()) {
                            return Arrays.asList(input.getTimestamp().getMillis(), input.getValue().getPagingIdentifiers(), input.getValue().getDimensions(), input.getValue().getMetrics(), input.getValue().getEvents(), dimOutputNames);
                        }
                        return Arrays.asList(input.getTimestamp().getMillis(), input.getValue().getPagingIdentifiers(), input.getValue().getDimensions(), input.getValue().getMetrics(), input.getValue().getEvents());
                    }
                };
            }

            @Override
            public Function<Object, Result<SelectResultValue>> pullFromCache(boolean isResultLevelCache) {
                return new Function<Object, Result<SelectResultValue>>(){
                    private final Granularity granularity;
                    {
                        this.granularity = query.getGranularity();
                    }

                    public Result<SelectResultValue> apply(Object input) {
                        List results = (List)input;
                        Iterator resultIter = results.iterator();
                        DateTime timestamp = this.granularity.toDateTime(((Number)resultIter.next()).longValue());
                        Map pageIdentifier = (Map)SelectQueryQueryToolChest.this.jsonMapper.convertValue(resultIter.next(), (TypeReference)new TypeReference<Map<String, Integer>>(){});
                        Set dimensionSet = (Set)SelectQueryQueryToolChest.this.jsonMapper.convertValue(resultIter.next(), (TypeReference)new TypeReference<Set<String>>(){});
                        Set metricSet = (Set)SelectQueryQueryToolChest.this.jsonMapper.convertValue(resultIter.next(), (TypeReference)new TypeReference<Set<String>>(){});
                        List eventHolders = (List)SelectQueryQueryToolChest.this.jsonMapper.convertValue(resultIter.next(), (TypeReference)new TypeReference<List<EventHolder>>(){});
                        if (resultIter.hasNext()) {
                            List cachedOutputNames = (List)resultIter.next();
                            Preconditions.checkArgument((cachedOutputNames.size() == dimOutputNames.size() ? 1 : 0) != 0, (Object)"Cache hit but different number of dimensions??");
                            for (int idx = 0; idx < dimOutputNames.size(); ++idx) {
                                if (((String)cachedOutputNames.get(idx)).equals(dimOutputNames.get(idx))) continue;
                                for (EventHolder eventHolder : eventHolders) {
                                    Object obj = eventHolder.getEvent().remove(cachedOutputNames.get(idx));
                                    if (obj == null) continue;
                                    eventHolder.getEvent().put((String)dimOutputNames.get(idx), obj);
                                }
                            }
                        }
                        return new Result<SelectResultValue>(timestamp, new SelectResultValue(pageIdentifier, dimensionSet, metricSet, eventHolders));
                    }
                };
            }
        };
    }

    @Override
    public QueryRunner<Result<SelectResultValue>> preMergeQueryDecoration(final QueryRunner<Result<SelectResultValue>> runner) {
        return this.intervalChunkingQueryRunnerDecorator.decorate(new QueryRunner<Result<SelectResultValue>>(){

            @Override
            public Sequence<Result<SelectResultValue>> run(QueryPlus<Result<SelectResultValue>> queryPlus, Map<String, Object> responseContext) {
                SelectQuery selectQuery = (SelectQuery)queryPlus.getQuery();
                if (selectQuery.getDimensionsFilter() != null) {
                    selectQuery = selectQuery.withDimFilter(selectQuery.getDimensionsFilter().optimize());
                    queryPlus = queryPlus.withQuery(selectQuery);
                }
                return runner.run(queryPlus, responseContext);
            }
        }, this);
    }

    @Override
    public <T extends LogicalSegment> List<T> filterSegments(SelectQuery query, List<T> segments) {
        String dataSource = (String)Iterables.getOnlyElement(query.getDataSource().getNames());
        PagingSpec pagingSpec = query.getPagingSpec();
        Map<String, Integer> paging = pagingSpec.getPagingIdentifiers();
        if (paging == null || paging.isEmpty()) {
            return segments;
        }
        Granularity granularity = query.getGranularity();
        TreeMap granularThresholds = new TreeMap();
        paging.keySet().stream().filter(identifier -> SegmentId.tryParse((String)dataSource, (String)identifier) != null).map(SegmentId.makeIntervalExtractor((String)dataSource)).sorted(query.isDescending() ? Comparators.intervalsByEndThenStart() : Comparators.intervalsByStartThenEnd()).forEach(interval -> {
            if (query.isDescending()) {
                long granularEnd = granularity.bucketStart(interval.getEnd()).getMillis();
                Long currentEnd = (Long)granularThresholds.get(granularEnd);
                if (currentEnd == null || interval.getEndMillis() > currentEnd) {
                    granularThresholds.put(granularEnd, interval.getEndMillis());
                }
            } else {
                long granularStart = granularity.bucketStart(interval.getStart()).getMillis();
                Long currentStart = (Long)granularThresholds.get(granularStart);
                if (currentStart == null || interval.getStartMillis() < currentStart) {
                    granularThresholds.put(granularStart, interval.getStartMillis());
                }
            }
        });
        ArrayList queryIntervals = Lists.newArrayList(segments);
        Iterator it = queryIntervals.iterator();
        if (query.isDescending()) {
            while (it.hasNext()) {
                Interval interval2 = ((LogicalSegment)it.next()).getInterval();
                Map.Entry ceiling = granularThresholds.ceilingEntry(granularity.bucketStart(interval2.getEnd()).getMillis());
                if (ceiling != null && interval2.getStartMillis() < (Long)ceiling.getValue()) continue;
                it.remove();
            }
        } else {
            while (it.hasNext()) {
                Interval interval3 = ((LogicalSegment)it.next()).getInterval();
                Map.Entry floor = granularThresholds.floorEntry(granularity.bucketStart(interval3.getStart()).getMillis());
                if (floor != null && interval3.getEndMillis() > (Long)floor.getValue()) continue;
                it.remove();
            }
        }
        return queryIntervals;
    }
}

