/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.spec;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.SequenceWrapper;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.Result;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.spec.SpecificSegmentSpec;
import org.apache.druid.segment.SegmentMissingException;

public class SpecificSegmentQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> base;
    private final SpecificSegmentSpec specificSpec;

    public SpecificSegmentQueryRunner(QueryRunner<T> base, SpecificSegmentSpec specificSpec) {
        this.base = base;
        this.specificSpec = specificSpec;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> input, final Map<String, Object> responseContext) {
        QueryPlus<T> queryPlus = input.withQuerySegmentSpec(this.specificSpec);
        Query<T> query = queryPlus.getQuery();
        final Thread currThread = Thread.currentThread();
        final String currThreadName = currThread.getName();
        final String newName = StringUtils.format((String)"%s_%s_%s", (Object[])new Object[]{query.getType(), query.getDataSource(), query.getIntervals()});
        final Sequence baseSequence = (Sequence)this.doNamed(currThread, currThreadName, newName, () -> this.base.run(queryPlus, responseContext));
        Sequence segmentMissingCatchingSequence = new Sequence<T>(){

            public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
                try {
                    return (OutType)baseSequence.accumulate(initValue, accumulator);
                }
                catch (SegmentMissingException e) {
                    SpecificSegmentQueryRunner.this.appendMissingSegment(responseContext);
                    return initValue;
                }
            }

            public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                try {
                    return this.makeYielder(baseSequence.toYielder(initValue, accumulator));
                }
                catch (SegmentMissingException e) {
                    SpecificSegmentQueryRunner.this.appendMissingSegment(responseContext);
                    return Yielders.done(initValue, null);
                }
            }

            private <OutType> Yielder<OutType> makeYielder(final Yielder<OutType> yielder) {
                return new Yielder<OutType>(){

                    public OutType get() {
                        return yielder.get();
                    }

                    public Yielder<OutType> next(OutType initValue) {
                        try {
                            return yielder.next(initValue);
                        }
                        catch (SegmentMissingException e) {
                            SpecificSegmentQueryRunner.this.appendMissingSegment(responseContext);
                            return Yielders.done(initValue, null);
                        }
                    }

                    public boolean isDone() {
                        return yielder.isDone();
                    }

                    public void close() throws IOException {
                        yielder.close();
                    }
                };
            }
        };
        return Sequences.wrap((Sequence)segmentMissingCatchingSequence, (SequenceWrapper)new SequenceWrapper(){

            public <RetType> RetType wrap(Supplier<RetType> sequenceProcessing) {
                return (RetType)SpecificSegmentQueryRunner.this.doNamed(currThread, currThreadName, newName, sequenceProcessing);
            }
        });
    }

    private void appendMissingSegment(Map<String, Object> responseContext) {
        ArrayList<SegmentDescriptor> missingSegments = (ArrayList<SegmentDescriptor>)responseContext.get(Result.MISSING_SEGMENTS_KEY);
        if (missingSegments == null) {
            missingSegments = new ArrayList<SegmentDescriptor>();
            responseContext.put(Result.MISSING_SEGMENTS_KEY, missingSegments);
        }
        missingSegments.add(this.specificSpec.getDescriptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <RetType> RetType doNamed(Thread currThread, String currName, String newName, Supplier<RetType> toRun) {
        try {
            currThread.setName(newName);
            Object object = toRun.get();
            return (RetType)object;
        }
        finally {
            currThread.setName(currName);
        }
    }
}

