/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.timeboundary;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.BySegmentSkippingQueryRunner;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.MetricManipulationFn;
import org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.druid.query.timeboundary.TimeBoundaryResultValue;
import org.apache.druid.timeline.LogicalSegment;
import org.joda.time.ReadableInterval;

public class TimeBoundaryQueryQueryToolChest
extends QueryToolChest<Result<TimeBoundaryResultValue>, TimeBoundaryQuery> {
    private static final byte TIMEBOUNDARY_QUERY = 3;
    private static final TypeReference<Result<TimeBoundaryResultValue>> TYPE_REFERENCE = new TypeReference<Result<TimeBoundaryResultValue>>(){};
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};
    private final GenericQueryMetricsFactory queryMetricsFactory;

    @VisibleForTesting
    public TimeBoundaryQueryQueryToolChest() {
        this(DefaultGenericQueryMetricsFactory.instance());
    }

    @Inject
    public TimeBoundaryQueryQueryToolChest(GenericQueryMetricsFactory queryMetricsFactory) {
        this.queryMetricsFactory = queryMetricsFactory;
    }

    @Override
    public <T extends LogicalSegment> List<T> filterSegments(TimeBoundaryQuery query, List<T> segments) {
        if (segments.size() <= 1 || query.hasFilters()) {
            return segments;
        }
        LogicalSegment min = query.isMaxTime() ? null : (LogicalSegment)segments.get(0);
        LogicalSegment max = query.isMinTime() ? null : (LogicalSegment)segments.get(segments.size() - 1);
        return segments.stream().filter(input -> min != null && input.getInterval().overlaps((ReadableInterval)min.getTrueInterval()) || max != null && input.getInterval().overlaps((ReadableInterval)max.getTrueInterval())).collect(Collectors.toList());
    }

    @Override
    public QueryRunner<Result<TimeBoundaryResultValue>> mergeResults(QueryRunner<Result<TimeBoundaryResultValue>> runner) {
        return new BySegmentSkippingQueryRunner<Result<TimeBoundaryResultValue>>(runner){

            @Override
            protected Sequence<Result<TimeBoundaryResultValue>> doRun(QueryRunner<Result<TimeBoundaryResultValue>> baseRunner, QueryPlus<Result<TimeBoundaryResultValue>> input, Map<String, Object> context) {
                TimeBoundaryQuery query = (TimeBoundaryQuery)input.getQuery();
                return Sequences.simple(query.mergeResults(baseRunner.run(input, context).toList()));
            }
        };
    }

    @Override
    public QueryMetrics<Query<?>> makeMetrics(TimeBoundaryQuery query) {
        return this.queryMetricsFactory.makeMetrics(query);
    }

    @Override
    public Function<Result<TimeBoundaryResultValue>, Result<TimeBoundaryResultValue>> makePreComputeManipulatorFn(TimeBoundaryQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }

    @Override
    public TypeReference<Result<TimeBoundaryResultValue>> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy<Result<TimeBoundaryResultValue>, Object, TimeBoundaryQuery> getCacheStrategy(TimeBoundaryQuery query) {
        return new CacheStrategy<Result<TimeBoundaryResultValue>, Object, TimeBoundaryQuery>(){

            @Override
            public boolean isCacheable(TimeBoundaryQuery query, boolean willMergeRunners) {
                return true;
            }

            @Override
            public byte[] computeCacheKey(TimeBoundaryQuery query) {
                byte[] cacheKey = query.getCacheKey();
                return ByteBuffer.allocate(1 + cacheKey.length).put((byte)3).put(cacheKey).array();
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<Result<TimeBoundaryResultValue>, Object> prepareForCache(boolean isResultLevelCache) {
                return new Function<Result<TimeBoundaryResultValue>, Object>(){

                    public Object apply(Result<TimeBoundaryResultValue> input) {
                        return Lists.newArrayList((Object[])new Object[]{input.getTimestamp().getMillis(), input.getValue()});
                    }
                };
            }

            @Override
            public Function<Object, Result<TimeBoundaryResultValue>> pullFromCache(boolean isResultLevelCache) {
                return new Function<Object, Result<TimeBoundaryResultValue>>(){

                    public Result<TimeBoundaryResultValue> apply(Object input) {
                        List result = (List)input;
                        return new Result<TimeBoundaryResultValue>(DateTimes.utc((long)((Number)result.get(0)).longValue()), new TimeBoundaryResultValue(result.get(1)));
                    }
                };
            }
        };
    }
}

