/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.ColumnSelectorPlus;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.AggregatorUtil;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.topn.BaseTopNAlgorithm;
import org.apache.druid.query.topn.DimValHolder;
import org.apache.druid.query.topn.PooledTopNAlgorithm;
import org.apache.druid.query.topn.TopNAlgorithm;
import org.apache.druid.query.topn.TopNParams;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.query.topn.TopNQueryMetrics;
import org.apache.druid.query.topn.TopNResultBuilder;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.StorageAdapter;

public class AggregateTopNMetricFirstAlgorithm
implements TopNAlgorithm<int[], TopNParams> {
    private final StorageAdapter storageAdapter;
    private final TopNQuery query;
    private final NonBlockingPool<ByteBuffer> bufferPool;

    public AggregateTopNMetricFirstAlgorithm(StorageAdapter storageAdapter, TopNQuery query, NonBlockingPool<ByteBuffer> bufferPool) {
        this.storageAdapter = storageAdapter;
        this.query = query;
        this.bufferPool = bufferPool;
    }

    @Override
    public TopNParams makeInitParams(ColumnSelectorPlus selectorPlus, Cursor cursor) {
        return new TopNParams(selectorPlus, cursor, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(TopNParams params, TopNResultBuilder resultBuilder, int[] ints, @Nullable TopNQueryMetrics queryMetrics) {
        int[] dimValSelector;
        String metric = this.query.getTopNMetricSpec().getMetricName(this.query.getDimensionSpec());
        Pair<List<AggregatorFactory>, List<PostAggregator>> condensedAggPostAggPair = AggregatorUtil.condensedAggregators(this.query.getAggregatorSpecs(), this.query.getPostAggregatorSpecs(), metric);
        if (((List)condensedAggPostAggPair.lhs).isEmpty() && ((List)condensedAggPostAggPair.rhs).isEmpty()) {
            throw new ISE("WTF! Can't find the metric to do topN over?", new Object[0]);
        }
        TopNQuery singleMetricQuery = new TopNQueryBuilder(this.query).aggregators((List)condensedAggPostAggPair.lhs).postAggregators((Collection)condensedAggPostAggPair.rhs).build();
        TopNResultBuilder singleMetricResultBuilder = BaseTopNAlgorithm.makeResultBuilder(params, singleMetricQuery);
        PooledTopNAlgorithm singleMetricAlgo = new PooledTopNAlgorithm(this.storageAdapter, singleMetricQuery, this.bufferPool);
        PooledTopNAlgorithm.PooledTopNParams singleMetricParam = null;
        try {
            singleMetricParam = singleMetricAlgo.makeInitParams((ColumnSelectorPlus)params.getSelectorPlus(), params.getCursor());
            singleMetricAlgo.run(singleMetricParam, singleMetricResultBuilder, null, null);
            dimValSelector = this.getDimValSelectorForTopNMetric(singleMetricParam, singleMetricResultBuilder);
            singleMetricAlgo.cleanup(singleMetricParam);
        }
        catch (Throwable throwable) {
            singleMetricAlgo.cleanup(singleMetricParam);
            throw throwable;
        }
        PooledTopNAlgorithm allMetricAlgo = new PooledTopNAlgorithm(this.storageAdapter, this.query, this.bufferPool);
        PooledTopNAlgorithm.PooledTopNParams allMetricsParam = null;
        try {
            allMetricsParam = allMetricAlgo.makeInitParams((ColumnSelectorPlus)params.getSelectorPlus(), params.getCursor());
            allMetricAlgo.run(allMetricsParam, resultBuilder, dimValSelector, queryMetrics);
            allMetricAlgo.cleanup(allMetricsParam);
        }
        catch (Throwable throwable) {
            allMetricAlgo.cleanup(allMetricsParam);
            throw throwable;
        }
    }

    @Override
    public void cleanup(TopNParams params) {
    }

    private int[] getDimValSelectorForTopNMetric(TopNParams params, TopNResultBuilder resultBuilder) {
        if (params.getCardinality() < 0) {
            throw new UnsupportedOperationException("Cannot operate on a dimension with unknown cardinality");
        }
        int[] dimValSelector = new int[params.getCardinality()];
        Arrays.fill(dimValSelector, -2);
        Iterator<DimValHolder> dimValIter = resultBuilder.getTopNIterator();
        while (dimValIter.hasNext()) {
            int dimValIndex = (Integer)dimValIter.next().getDimValIndex();
            dimValSelector[dimValIndex] = -1;
        }
        return dimValSelector;
    }
}

