/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.topn.LexicographicTopNMetricSpec;
import org.apache.druid.query.topn.TopNMetricSpecBuilder;

public class AlphaNumericTopNMetricSpec
extends LexicographicTopNMetricSpec {
    private static final byte CACHE_TYPE_ID = 2;
    protected static Comparator<String> comparator = StringComparators.ALPHANUMERIC;

    @JsonCreator
    public AlphaNumericTopNMetricSpec(@JsonProperty(value="previousStop") String previousStop) {
        super(previousStop);
    }

    @Override
    public Comparator getComparator(List<AggregatorFactory> aggregatorSpecs, List<PostAggregator> postAggregatorSpecs) {
        return comparator;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] previousStopBytes = this.getPreviousStop() == null ? new byte[]{} : StringUtils.toUtf8((String)this.getPreviousStop());
        return ByteBuffer.allocate(1 + previousStopBytes.length).put((byte)2).put(previousStopBytes).array();
    }

    @Override
    public <T> TopNMetricSpecBuilder<T> configureOptimizer(TopNMetricSpecBuilder<T> builder) {
        return builder;
    }

    @Override
    public String toString() {
        return "AlphaNumericTopNMetricSpec{previousStop='" + this.getPreviousStop() + '\'' + '}';
    }
}

