/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import java.util.HashMap;
import java.util.Map;
import org.apache.druid.query.ColumnSelectorPlus;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.topn.BaseTopNAlgorithm;
import org.apache.druid.query.topn.TopNParams;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNResultBuilder;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.StorageAdapter;

public class TimeExtractionTopNAlgorithm
extends BaseTopNAlgorithm<int[], Map<String, Aggregator[]>, TopNParams> {
    public static final int[] EMPTY_INTS = new int[0];
    private final TopNQuery query;

    public TimeExtractionTopNAlgorithm(StorageAdapter storageAdapter, TopNQuery query) {
        super(storageAdapter);
        this.query = query;
    }

    @Override
    public TopNParams makeInitParams(ColumnSelectorPlus selectorPlus, Cursor cursor) {
        return new TopNParams(selectorPlus, cursor, Integer.MAX_VALUE);
    }

    @Override
    protected int[] makeDimValSelector(TopNParams params, int numProcessed, int numToProcess) {
        return EMPTY_INTS;
    }

    @Override
    protected int[] updateDimValSelector(int[] dimValSelector, int numProcessed, int numToProcess) {
        return dimValSelector;
    }

    @Override
    protected Map<String, Aggregator[]> makeDimValAggregateStore(TopNParams params) {
        return new HashMap<String, Aggregator[]>();
    }

    @Override
    protected long scanAndAggregate(TopNParams params, int[] dimValSelector, Map<String, Aggregator[]> aggregatesStore) {
        if (params.getCardinality() < 0) {
            throw new UnsupportedOperationException("Cannot operate on a dimension with unknown cardinality");
        }
        Cursor cursor = params.getCursor();
        DimensionSelector dimSelector = params.getDimSelector();
        long processedRows = 0L;
        while (!cursor.isDone()) {
            String key = dimSelector.lookupName(dimSelector.getRow().get(0));
            Aggregator[] theAggregators = aggregatesStore.get(key);
            if (theAggregators == null) {
                theAggregators = TimeExtractionTopNAlgorithm.makeAggregators(cursor, this.query.getAggregatorSpecs());
                aggregatesStore.put(key, theAggregators);
            }
            for (Aggregator aggregator : theAggregators) {
                aggregator.aggregate();
            }
            cursor.advance();
            ++processedRows;
        }
        return processedRows;
    }

    @Override
    protected void updateResults(TopNParams params, int[] dimValSelector, Map<String, Aggregator[]> aggregatesStore, TopNResultBuilder resultBuilder) {
        for (Map.Entry<String, Aggregator[]> entry : aggregatesStore.entrySet()) {
            Aggregator[] aggs = entry.getValue();
            if (aggs == null) continue;
            Object[] vals = new Object[aggs.length];
            for (int i = 0; i < aggs.length; ++i) {
                vals[i] = aggs[i].get();
            }
            resultBuilder.addEntry((Comparable)((Object)entry.getKey()), entry.getKey(), vals);
        }
    }

    @Override
    protected void closeAggregators(Map<String, Aggregator[]> stringMap) {
        for (Aggregator[] aggregators : stringMap.values()) {
            for (Aggregator agg : aggregators) {
                agg.close();
            }
        }
    }

    @Override
    public void cleanup(TopNParams params) {
    }
}

