/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import org.apache.druid.query.ColumnSelectorPlus;
import org.apache.druid.query.topn.types.TopNColumnSelectorStrategy;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionSelector;

public class TopNParams {
    private final Cursor cursor;
    private final int cardinality;
    private final int numValuesPerPass;
    private final ColumnSelectorPlus<TopNColumnSelectorStrategy> selectorPlus;

    protected TopNParams(ColumnSelectorPlus<TopNColumnSelectorStrategy> selectorPlus, Cursor cursor, int numValuesPerPass) {
        this.selectorPlus = selectorPlus;
        this.cursor = cursor;
        this.cardinality = selectorPlus.getColumnSelectorStrategy().getCardinality(selectorPlus.getSelector());
        this.numValuesPerPass = numValuesPerPass;
    }

    public DimensionSelector getDimSelector() {
        return (DimensionSelector)this.selectorPlus.getSelector();
    }

    public ColumnSelectorPlus<TopNColumnSelectorStrategy> getSelectorPlus() {
        return this.selectorPlus;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public int getNumValuesPerPass() {
        return this.numValuesPerPass;
    }
}

