/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn.types;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.topn.BaseTopNAlgorithm;
import org.apache.druid.query.topn.TopNParams;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNResultBuilder;
import org.apache.druid.query.topn.types.TopNColumnSelectorStrategy;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.column.ValueType;

public abstract class NumericTopNColumnSelectorStrategy<ValueSelectorType, DimExtractionAggregateStoreType extends Map<?, Aggregator[]>>
implements TopNColumnSelectorStrategy<ValueSelectorType, DimExtractionAggregateStoreType> {
    public static TopNColumnSelectorStrategy ofType(ValueType selectorType, ValueType dimensionType) {
        Function<Object, Comparable<?>> converter = DimensionHandlerUtils.converterFromTypeToType(selectorType, dimensionType);
        switch (selectorType) {
            case LONG: {
                return new OfLong(converter);
            }
            case FLOAT: {
                return new OfFloat(converter);
            }
            case DOUBLE: {
                return new OfDouble(converter);
            }
        }
        throw new IAE("No strategy for type[%s]", new Object[]{selectorType});
    }

    @Override
    public int getCardinality(ValueSelectorType selector) {
        return -1;
    }

    @Override
    public Aggregator[][] getDimExtractionRowSelector(TopNQuery query, TopNParams params, StorageAdapter storageAdapter) {
        return null;
    }

    static long floatDimExtractionScanAndAggregate(TopNQuery query, BaseFloatColumnValueSelector selector, Cursor cursor, Int2ObjectMap<Aggregator[]> aggregatesStore) {
        long processedRows = 0L;
        while (!cursor.isDone()) {
            int key = Float.floatToIntBits(selector.getFloat());
            Aggregator[] theAggregators = (Aggregator[])aggregatesStore.get(key);
            if (theAggregators == null) {
                theAggregators = BaseTopNAlgorithm.makeAggregators(cursor, query.getAggregatorSpecs());
                aggregatesStore.put(key, (Object)theAggregators);
            }
            for (Aggregator aggregator : theAggregators) {
                aggregator.aggregate();
            }
            cursor.advance();
            ++processedRows;
        }
        return processedRows;
    }

    static long doubleDimExtractionScanAndAggregate(TopNQuery query, BaseDoubleColumnValueSelector selector, Cursor cursor, Long2ObjectMap<Aggregator[]> aggregatesStore) {
        long processedRows = 0L;
        while (!cursor.isDone()) {
            long key = Double.doubleToLongBits(selector.getDouble());
            Aggregator[] theAggregators = (Aggregator[])aggregatesStore.get(key);
            if (theAggregators == null) {
                theAggregators = BaseTopNAlgorithm.makeAggregators(cursor, query.getAggregatorSpecs());
                aggregatesStore.put(key, (Object)theAggregators);
            }
            for (Aggregator aggregator : theAggregators) {
                aggregator.aggregate();
            }
            cursor.advance();
            ++processedRows;
        }
        return processedRows;
    }

    static long longDimExtractionScanAndAggregate(TopNQuery query, BaseLongColumnValueSelector selector, Cursor cursor, Long2ObjectMap<Aggregator[]> aggregatesStore) {
        long processedRows = 0L;
        while (!cursor.isDone()) {
            long key = selector.getLong();
            Aggregator[] theAggregators = (Aggregator[])aggregatesStore.get(key);
            if (theAggregators == null) {
                theAggregators = BaseTopNAlgorithm.makeAggregators(cursor, query.getAggregatorSpecs());
                aggregatesStore.put(key, (Object)theAggregators);
            }
            for (Aggregator aggregator : theAggregators) {
                aggregator.aggregate();
            }
            cursor.advance();
            ++processedRows;
        }
        return processedRows;
    }

    @Override
    public void updateDimExtractionResults(DimExtractionAggregateStoreType aggregatesStore, TopNResultBuilder resultBuilder) {
        for (Map.Entry entry : aggregatesStore.entrySet()) {
            Aggregator[] aggs = (Aggregator[])entry.getValue();
            if (aggs == null) continue;
            Object[] vals = new Object[aggs.length];
            for (int i = 0; i < aggs.length; ++i) {
                vals[i] = aggs[i].get();
            }
            Comparable key = this.convertAggregatorStoreKeyToColumnValue(entry.getKey());
            resultBuilder.addEntry(key, key, vals);
        }
    }

    abstract Comparable convertAggregatorStoreKeyToColumnValue(Object var1);

    static class OfDouble
    extends NumericTopNColumnSelectorStrategy<BaseDoubleColumnValueSelector, Long2ObjectMap<Aggregator[]>> {
        private final Function<Object, Comparable<?>> converter;

        OfDouble(Function<Object, Comparable<?>> converter) {
            this.converter = converter;
        }

        @Override
        public Long2ObjectMap<Aggregator[]> makeDimExtractionAggregateStore() {
            return new Long2ObjectOpenHashMap();
        }

        @Override
        Comparable convertAggregatorStoreKeyToColumnValue(Object aggregatorStoreKey) {
            return this.converter.apply(Double.longBitsToDouble((Long)aggregatorStoreKey));
        }

        @Override
        public long dimExtractionScanAndAggregate(TopNQuery query, BaseDoubleColumnValueSelector selector, Cursor cursor, Aggregator[][] rowSelector, Long2ObjectMap<Aggregator[]> aggregatesStore) {
            return OfDouble.doubleDimExtractionScanAndAggregate(query, selector, cursor, aggregatesStore);
        }
    }

    static class OfLong
    extends NumericTopNColumnSelectorStrategy<BaseLongColumnValueSelector, Long2ObjectMap<Aggregator[]>> {
        private final Function<Object, Comparable<?>> converter;

        OfLong(Function<Object, Comparable<?>> converter) {
            this.converter = converter;
        }

        @Override
        public Long2ObjectMap<Aggregator[]> makeDimExtractionAggregateStore() {
            return new Long2ObjectOpenHashMap();
        }

        @Override
        Comparable convertAggregatorStoreKeyToColumnValue(Object aggregatorStoreKey) {
            return this.converter.apply(aggregatorStoreKey);
        }

        @Override
        public long dimExtractionScanAndAggregate(TopNQuery query, BaseLongColumnValueSelector selector, Cursor cursor, Aggregator[][] rowSelector, Long2ObjectMap<Aggregator[]> aggregatesStore) {
            return OfLong.longDimExtractionScanAndAggregate(query, selector, cursor, aggregatesStore);
        }
    }

    static class OfFloat
    extends NumericTopNColumnSelectorStrategy<BaseFloatColumnValueSelector, Int2ObjectMap<Aggregator[]>> {
        private final Function<Object, Comparable<?>> converter;

        OfFloat(Function<Object, Comparable<?>> converter) {
            this.converter = converter;
        }

        @Override
        public Int2ObjectMap<Aggregator[]> makeDimExtractionAggregateStore() {
            return new Int2ObjectOpenHashMap();
        }

        @Override
        Comparable convertAggregatorStoreKeyToColumnValue(Object aggregatorStoreKey) {
            return this.converter.apply(Float.valueOf(Float.intBitsToFloat((Integer)aggregatorStoreKey)));
        }

        @Override
        public long dimExtractionScanAndAggregate(TopNQuery query, BaseFloatColumnValueSelector selector, Cursor cursor, Aggregator[][] rowSelector, Int2ObjectMap<Aggregator[]> aggregatesStore) {
            return OfFloat.floatDimExtractionScanAndAggregate(query, selector, cursor, aggregatesStore);
        }
    }
}

