/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn.types;

import com.google.common.base.Preconditions;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.dimension.ColumnSelectorStrategyFactory;
import org.apache.druid.query.topn.types.NumericTopNColumnSelectorStrategy;
import org.apache.druid.query.topn.types.StringTopNColumnSelectorStrategy;
import org.apache.druid.query.topn.types.TopNColumnSelectorStrategy;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;

public class TopNColumnSelectorStrategyFactory
implements ColumnSelectorStrategyFactory<TopNColumnSelectorStrategy> {
    private final ValueType dimensionType;

    public TopNColumnSelectorStrategyFactory(ValueType dimensionType) {
        this.dimensionType = (ValueType)((Object)Preconditions.checkNotNull((Object)((Object)dimensionType), (Object)"dimensionType"));
    }

    @Override
    public TopNColumnSelectorStrategy makeColumnSelectorStrategy(ColumnCapabilities capabilities, ColumnValueSelector selector) {
        ValueType selectorType = capabilities.getType();
        switch (selectorType) {
            case STRING: {
                return new StringTopNColumnSelectorStrategy(this.dimensionType);
            }
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                if (ValueType.isNumeric(this.dimensionType)) {
                    return NumericTopNColumnSelectorStrategy.ofType(this.dimensionType, this.dimensionType);
                }
                return NumericTopNColumnSelectorStrategy.ofType(selectorType, this.dimensionType);
            }
        }
        throw new IAE("Cannot create query type helper from invalid type [%s]", new Object[]{selectorType});
    }
}

