/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.druid.common.utils.SerializerUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.data.CompressedColumnarFloatsSupplier;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;

public class MetricHolder {
    private static final byte[] version = new byte[]{0};
    private static final SerializerUtils serializerUtils = new SerializerUtils();
    private final String name;
    private final String typeName;
    private final MetricType type;
    CompressedColumnarFloatsSupplier floatType = null;
    GenericIndexed<?> complexType = null;

    public static MetricHolder fromByteBuffer(ByteBuffer buf) {
        byte ver = buf.get();
        if (version[0] != ver) {
            throw new ISE("Unknown version[%s] of MetricHolder", new Object[]{ver});
        }
        String metricName = serializerUtils.readString(buf);
        String typeName = serializerUtils.readString(buf);
        MetricHolder holder = new MetricHolder(metricName, typeName);
        switch (holder.type) {
            case FLOAT: {
                holder.floatType = CompressedColumnarFloatsSupplier.fromByteBuffer(buf, ByteOrder.nativeOrder());
                break;
            }
            case COMPLEX: {
                ComplexMetricSerde serdeForType = ComplexMetrics.getSerdeForType(holder.getTypeName());
                if (serdeForType == null) {
                    throw new ISE("Unknown type[%s], cannot load.", new Object[]{holder.getTypeName()});
                }
                holder.complexType = MetricHolder.read(buf, serdeForType);
                break;
            }
            case LONG: 
            case DOUBLE: {
                throw new ISE("Unsupported type[%s]", new Object[]{holder.type});
            }
        }
        return holder;
    }

    private static <T> GenericIndexed<T> read(ByteBuffer buf, ComplexMetricSerde serde) {
        return GenericIndexed.read(buf, serde.getObjectStrategy());
    }

    private MetricHolder(String name, String typeName) {
        this.name = name;
        this.typeName = typeName;
        this.type = MetricType.determineType(typeName);
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public MetricType getType() {
        return this.type;
    }

    public static enum MetricType {
        LONG,
        FLOAT,
        DOUBLE,
        COMPLEX;


        static MetricType determineType(String typeName) {
            if ("long".equalsIgnoreCase(typeName)) {
                return LONG;
            }
            if ("float".equalsIgnoreCase(typeName)) {
                return FLOAT;
            }
            if ("double".equalsIgnoreCase(typeName)) {
                return DOUBLE;
            }
            return COMPLEX;
        }
    }
}

