/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.SingleIndexedInt;

public class SingleScanTimeDimensionSelector
implements DimensionSelector {
    private final ExtractionFn extractionFn;
    private final BaseLongColumnValueSelector selector;
    private final boolean descending;
    private final List<String> timeValues = new ArrayList<String>();
    private final SingleIndexedInt row = new SingleIndexedInt();
    private String currentValue = null;
    private long currentTimestamp = Long.MIN_VALUE;
    private int index = -1;

    public SingleScanTimeDimensionSelector(BaseLongColumnValueSelector selector, @Nullable ExtractionFn extractionFn, boolean descending) {
        Preconditions.checkNotNull((Object)extractionFn, (Object)"time dimension must provide an extraction function");
        this.extractionFn = extractionFn;
        this.selector = selector;
        this.descending = descending;
    }

    @Override
    public IndexedInts getRow() {
        this.row.setValue(this.getDimensionValueIndex());
        return this.row;
    }

    @Override
    public ValueMatcher makeValueMatcher(final @Nullable String value) {
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return Objects.equals(SingleScanTimeDimensionSelector.this.lookupName(SingleScanTimeDimensionSelector.this.getDimensionValueIndex()), value);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", SingleScanTimeDimensionSelector.this);
            }
        };
    }

    @Override
    public ValueMatcher makeValueMatcher(final Predicate<String> predicate) {
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return predicate.apply((Object)SingleScanTimeDimensionSelector.this.lookupName(SingleScanTimeDimensionSelector.this.getDimensionValueIndex()));
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", SingleScanTimeDimensionSelector.this);
                inspector.visit("predicate", predicate);
            }
        };
    }

    private int getDimensionValueIndex() {
        long timestamp = this.selector.getLong();
        if (this.index < 0) {
            this.currentTimestamp = timestamp;
            this.currentValue = this.extractionFn.apply(timestamp);
            ++this.index;
            this.timeValues.add(this.currentValue);
        } else if (timestamp != this.currentTimestamp) {
            if (this.descending ? timestamp > this.currentTimestamp : timestamp < this.currentTimestamp) {
                throw new IllegalStateException("cannot re-use time dimension selector for multiple scans");
            }
            this.currentTimestamp = timestamp;
            String value = this.extractionFn.apply(timestamp);
            if (!Objects.equals(value, this.currentValue)) {
                this.currentValue = value;
                ++this.index;
                this.timeValues.add(this.currentValue);
            }
        }
        return this.index;
    }

    @Override
    public int getValueCardinality() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String lookupName(int id) {
        if (id == this.index) {
            return this.currentValue;
        }
        return this.timeValues.get(id);
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return false;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return null;
    }

    @Override
    @Nullable
    public String getObject() {
        return this.currentValue;
    }

    @Override
    public Class<String> classOfObject() {
        return String.class;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
        inspector.visit("extractionFn", this.extractionFn);
        inspector.visit("descending", this.descending);
    }
}

