/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.serde.ColumnPartSerde;
import org.apache.druid.segment.serde.Serializer;

public class ColumnDescriptor
implements Serializer {
    private final ValueType valueType;
    private final boolean hasMultipleValues;
    private final List<ColumnPartSerde> parts;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator
    public ColumnDescriptor(@JsonProperty(value="valueType") ValueType valueType, @JsonProperty(value="hasMultipleValues") boolean hasMultipleValues, @JsonProperty(value="parts") List<ColumnPartSerde> parts) {
        this.valueType = valueType;
        this.hasMultipleValues = hasMultipleValues;
        this.parts = parts;
    }

    @JsonProperty
    public ValueType getValueType() {
        return this.valueType;
    }

    @JsonProperty
    public boolean isHasMultipleValues() {
        return this.hasMultipleValues;
    }

    @JsonProperty
    public List<ColumnPartSerde> getParts() {
        return this.parts;
    }

    @Override
    public long getSerializedSize() throws IOException {
        long size = 0L;
        for (ColumnPartSerde part : this.parts) {
            size += part.getSerializer().getSerializedSize();
        }
        return size;
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        for (ColumnPartSerde part : this.parts) {
            part.getSerializer().writeTo(channel, smoosher);
        }
    }

    public ColumnHolder read(ByteBuffer buffer, ColumnConfig columnConfig, SmooshedFileMapper smooshedFiles) {
        ColumnBuilder builder = new ColumnBuilder().setType(this.valueType).setHasMultipleValues(this.hasMultipleValues).setFileMapper(smooshedFiles);
        for (ColumnPartSerde part : this.parts) {
            part.getDeserializer().read(buffer, builder, columnConfig);
        }
        return builder.build();
    }

    public static class Builder {
        private ValueType valueType = null;
        private Boolean hasMultipleValues = null;
        private final List<ColumnPartSerde> parts = new ArrayList<ColumnPartSerde>();

        public Builder setValueType(ValueType valueType) {
            if (this.valueType != null && this.valueType != valueType) {
                throw new IAE("valueType[%s] is already set, cannot change to[%s]", new Object[]{this.valueType, valueType});
            }
            this.valueType = valueType;
            return this;
        }

        public Builder setHasMultipleValues(boolean hasMultipleValues) {
            if (this.hasMultipleValues != null && this.hasMultipleValues != hasMultipleValues) {
                throw new IAE("hasMultipleValues[%s] is already set, cannot change to[%s]", new Object[]{this.hasMultipleValues, hasMultipleValues});
            }
            this.hasMultipleValues = hasMultipleValues;
            return this;
        }

        public Builder addSerde(ColumnPartSerde serde) {
            this.parts.add(serde);
            return this;
        }

        public ColumnDescriptor build() {
            Preconditions.checkNotNull((Object)((Object)this.valueType), (Object)"must specify a valueType");
            return new ColumnDescriptor(this.valueType, this.hasMultipleValues == null ? false : this.hasMultipleValues, this.parts);
        }
    }
}

