/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.column.FloatsColumnWithNulls;
import org.apache.druid.segment.column.NumericColumn;
import org.apache.druid.segment.data.ColumnarFloats;
import org.apache.druid.segment.data.ReadableOffset;

public class FloatsColumn
implements NumericColumn {
    final ColumnarFloats column;

    public static FloatsColumn create(ColumnarFloats column, ImmutableBitmap nullValueBitmap) {
        if (nullValueBitmap.isEmpty()) {
            return new FloatsColumn(column);
        }
        return new FloatsColumnWithNulls(column, nullValueBitmap);
    }

    FloatsColumn(ColumnarFloats column) {
        this.column = column;
    }

    @Override
    public int length() {
        return this.column.size();
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(ReadableOffset offset) {
        return this.column.makeColumnValueSelector(offset, IndexIO.LEGACY_FACTORY.getBitmapFactory().makeEmptyImmutableBitmap());
    }

    @Override
    public long getLongSingleValueRow(int rowNum) {
        return (long)this.column.get(rowNum);
    }

    @Override
    public void close() {
        this.column.close();
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("column", this.column);
    }
}

