/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.util.BitSet;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.guava.CloseQuietly;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.AbstractDimensionSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.data.CachingIndexed;
import org.apache.druid.segment.data.ColumnarInts;
import org.apache.druid.segment.data.ColumnarMultiInts;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.data.SingleIndexedInt;
import org.apache.druid.segment.filter.BooleanValueMatcher;
import org.apache.druid.segment.historical.HistoricalDimensionSelector;
import org.apache.druid.segment.historical.SingleValueHistoricalDimensionSelector;

public class StringDictionaryEncodedColumn
implements DictionaryEncodedColumn<String> {
    @Nullable
    private final ColumnarInts column;
    @Nullable
    private final ColumnarMultiInts multiValueColumn;
    private final CachingIndexed<String> cachedLookups;

    public StringDictionaryEncodedColumn(@Nullable ColumnarInts singleValueColumn, @Nullable ColumnarMultiInts multiValueColumn, CachingIndexed<String> cachedLookups) {
        this.column = singleValueColumn;
        this.multiValueColumn = multiValueColumn;
        this.cachedLookups = cachedLookups;
    }

    @Override
    public int length() {
        return this.hasMultipleValues() ? this.multiValueColumn.size() : this.column.size();
    }

    @Override
    public boolean hasMultipleValues() {
        return this.column == null;
    }

    @Override
    public int getSingleValueRow(int rowNum) {
        return this.column.get(rowNum);
    }

    @Override
    public IndexedInts getMultiValueRow(int rowNum) {
        return this.multiValueColumn.get(rowNum);
    }

    @Override
    @Nullable
    public String lookupName(int id) {
        return this.cachedLookups.get(id);
    }

    @Override
    public int lookupId(String name) {
        return this.cachedLookups.indexOf(name);
    }

    @Override
    public int getCardinality() {
        return this.cachedLookups.size();
    }

    @Override
    public HistoricalDimensionSelector makeDimensionSelector(final ReadableOffset offset, final @Nullable ExtractionFn extractionFn) {
        if (this.hasMultipleValues()) {
            class MultiValueDimensionSelector
            extends 1QueryableDimensionSelector {
                MultiValueDimensionSelector() {
                    abstract class QueryableDimensionSelector
                    extends AbstractDimensionSelector
                    implements HistoricalDimensionSelector,
                    IdLookup {
                        final /* synthetic */ ExtractionFn val$extractionFn;

                        QueryableDimensionSelector() {
                            this.val$extractionFn = extractionFn;
                        }

                        @Override
                        public int getValueCardinality() {
                            return StringDictionaryEncodedColumn.this.getCardinality();
                        }

                        @Override
                        public String lookupName(int id) {
                            String value = StringDictionaryEncodedColumn.this.lookupName(id);
                            return this.val$extractionFn == null ? value : this.val$extractionFn.apply(value);
                        }

                        @Override
                        public boolean nameLookupPossibleInAdvance() {
                            return true;
                        }

                        @Override
                        @Nullable
                        public IdLookup idLookup() {
                            return this.val$extractionFn == null ? this : null;
                        }

                        @Override
                        public int lookupId(String name) {
                            if (this.val$extractionFn != null) {
                                throw new UnsupportedOperationException("cannot perform lookup when applying an extraction function");
                            }
                            return StringDictionaryEncodedColumn.this.lookupId(name);
                        }
                    }
                    super(StringDictionaryEncodedColumn.this, extractionFn2);
                }

                @Override
                public IndexedInts getRow() {
                    return StringDictionaryEncodedColumn.this.multiValueColumn.get(offset.getOffset());
                }

                @Override
                public IndexedInts getRow(int offset2) {
                    return StringDictionaryEncodedColumn.this.multiValueColumn.get(offset2);
                }

                @Override
                public ValueMatcher makeValueMatcher(@Nullable String value) {
                    return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, value);
                }

                @Override
                public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
                    return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicate);
                }

                @Override
                @Nullable
                public Object getObject() {
                    return this.defaultGetObject();
                }

                @Override
                public Class classOfObject() {
                    return Object.class;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("multiValueColumn", StringDictionaryEncodedColumn.this.multiValueColumn);
                    inspector.visit("offset", offset);
                    inspector.visit("extractionFn", extractionFn);
                }
            }
            return new MultiValueDimensionSelector();
        }
        class SingleValueQueryableDimensionSelector
        extends 1QueryableDimensionSelector
        implements SingleValueHistoricalDimensionSelector {
            private final SingleIndexedInt row;

            SingleValueQueryableDimensionSelector() {
                super(StringDictionaryEncodedColumn.this, extractionFn2);
                this.row = new SingleIndexedInt();
            }

            @Override
            public IndexedInts getRow() {
                this.row.setValue(this.getRowValue());
                return this.row;
            }

            public int getRowValue() {
                return StringDictionaryEncodedColumn.this.column.get(offset.getOffset());
            }

            @Override
            public IndexedInts getRow(int offset2) {
                this.row.setValue(this.getRowValue(offset2));
                return this.row;
            }

            @Override
            public int getRowValue(int offset2) {
                return StringDictionaryEncodedColumn.this.column.get(offset2);
            }

            @Override
            public ValueMatcher makeValueMatcher(@Nullable String value) {
                if (extractionFn == null) {
                    final int valueId = this.lookupId(value);
                    if (valueId >= 0) {
                        return new ValueMatcher(){

                            @Override
                            public boolean matches() {
                                return this.getRowValue() == valueId;
                            }

                            @Override
                            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                                inspector.visit("column", StringDictionaryEncodedColumn.this);
                            }
                        };
                    }
                    return BooleanValueMatcher.of(false);
                }
                return this.makeValueMatcher((Predicate<String>)Predicates.equalTo((Object)value));
            }

            @Override
            public ValueMatcher makeValueMatcher(final Predicate<String> predicate) {
                final BitSet checkedIds = new BitSet(StringDictionaryEncodedColumn.this.getCardinality());
                final BitSet matchingIds = new BitSet(StringDictionaryEncodedColumn.this.getCardinality());
                return new ValueMatcher(){

                    @Override
                    public boolean matches() {
                        int id = this.getRowValue();
                        if (checkedIds.get(id)) {
                            return matchingIds.get(id);
                        }
                        boolean matches = predicate.apply((Object)this.lookupName(id));
                        checkedIds.set(id);
                        if (matches) {
                            matchingIds.set(id);
                        }
                        return matches;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("column", StringDictionaryEncodedColumn.this);
                    }
                };
            }

            @Override
            public Object getObject() {
                return this.lookupName(this.getRowValue());
            }

            @Override
            public Class classOfObject() {
                return String.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("column", StringDictionaryEncodedColumn.this.column);
                inspector.visit("offset", offset);
                inspector.visit("extractionFn", extractionFn);
            }
        }
        return new SingleValueQueryableDimensionSelector();
    }

    @Override
    public void close() throws IOException {
        CloseQuietly.close(this.cachedLookups);
        if (this.column != null) {
            this.column.close();
        }
        if (this.multiValueColumn != null) {
            this.multiValueColumn.close();
        }
    }
}

