/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.base.Supplier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.guava.CloseQuietly;
import org.apache.druid.segment.data.ColumnarDoubles;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.DecompressingByteBufferObjectStrategy;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;

public class BlockLayoutColumnarDoublesSupplier
implements Supplier<ColumnarDoubles> {
    private final GenericIndexed<ResourceHolder<ByteBuffer>> baseDoubleBuffers;
    private final int totalSize;
    private final int sizePer;

    public BlockLayoutColumnarDoublesSupplier(int totalSize, int sizePer, ByteBuffer fromBuffer, ByteOrder byteOrder, CompressionStrategy strategy) {
        this.baseDoubleBuffers = GenericIndexed.read(fromBuffer, new DecompressingByteBufferObjectStrategy(byteOrder, strategy));
        this.totalSize = totalSize;
        this.sizePer = sizePer;
    }

    public ColumnarDoubles get() {
        boolean isPowerOf2;
        final int div = Integer.numberOfTrailingZeros(this.sizePer);
        final int rem = this.sizePer - 1;
        boolean bl = isPowerOf2 = this.sizePer == 1 << div;
        if (isPowerOf2) {
            return new BlockLayoutColumnarDoubles(){

                @Override
                public double get(int index) {
                    int bufferNum = index >> div;
                    if (bufferNum != this.currBufferNum) {
                        this.loadBuffer(bufferNum);
                    }
                    int bufferIndex = index & rem;
                    return this.doubleBuffer.get(bufferIndex);
                }
            };
        }
        return new BlockLayoutColumnarDoubles();
    }

    private class BlockLayoutColumnarDoubles
    implements ColumnarDoubles {
        final Indexed<ResourceHolder<ByteBuffer>> singleThreadedDoubleBuffers;
        int currBufferNum;
        ResourceHolder<ByteBuffer> holder;
        DoubleBuffer doubleBuffer;

        private BlockLayoutColumnarDoubles() {
            this.singleThreadedDoubleBuffers = BlockLayoutColumnarDoublesSupplier.this.baseDoubleBuffers.singleThreaded();
            this.currBufferNum = -1;
        }

        @Override
        public int size() {
            return BlockLayoutColumnarDoublesSupplier.this.totalSize;
        }

        @Override
        public double get(int index) {
            int bufferNum = index / BlockLayoutColumnarDoublesSupplier.this.sizePer;
            int bufferIndex = index % BlockLayoutColumnarDoublesSupplier.this.sizePer;
            if (bufferNum != this.currBufferNum) {
                this.loadBuffer(bufferNum);
            }
            return this.doubleBuffer.get(bufferIndex);
        }

        protected void loadBuffer(int bufferNum) {
            CloseQuietly.close(this.holder);
            this.holder = this.singleThreadedDoubleBuffers.get(bufferNum);
            this.doubleBuffer = ((ByteBuffer)this.holder.get()).asDoubleBuffer();
            this.currBufferNum = bufferNum;
        }

        @Override
        public void close() {
            if (this.holder != null) {
                this.holder.close();
            }
        }

        public String toString() {
            return "BlockCompressedColumnarDoubles_Anonymous{currBufferNum=" + this.currBufferNum + ", sizePer=" + BlockLayoutColumnarDoublesSupplier.this.sizePer + ", numChunks=" + this.singleThreadedDoubleBuffers.size() + ", totalSize=" + BlockLayoutColumnarDoublesSupplier.this.totalSize + '}';
        }
    }
}

