/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.base.Supplier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.CloseQuietly;
import org.apache.druid.segment.data.ColumnarFloats;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.DecompressingByteBufferObjectStrategy;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;

public class BlockLayoutColumnarFloatsSupplier
implements Supplier<ColumnarFloats> {
    private final GenericIndexed<ResourceHolder<ByteBuffer>> baseFloatBuffers;
    private final int totalSize;
    private final int sizePer;

    public BlockLayoutColumnarFloatsSupplier(int totalSize, int sizePer, ByteBuffer fromBuffer, ByteOrder byteOrder, CompressionStrategy strategy) {
        this.baseFloatBuffers = GenericIndexed.read(fromBuffer, new DecompressingByteBufferObjectStrategy(byteOrder, strategy));
        this.totalSize = totalSize;
        this.sizePer = sizePer;
    }

    public ColumnarFloats get() {
        boolean isPowerOf2;
        final int div = Integer.numberOfTrailingZeros(this.sizePer);
        final int rem = this.sizePer - 1;
        boolean bl = isPowerOf2 = this.sizePer == 1 << div;
        if (isPowerOf2) {
            return new BlockLayoutColumnarFloats(){

                @Override
                public float get(int index) {
                    int bufferNum = index >> div;
                    if (bufferNum != this.currBufferNum) {
                        this.loadBuffer(bufferNum);
                    }
                    int bufferIndex = index & rem;
                    return this.floatBuffer.get(bufferIndex);
                }
            };
        }
        return new BlockLayoutColumnarFloats();
    }

    private class BlockLayoutColumnarFloats
    implements ColumnarFloats {
        final Indexed<ResourceHolder<ByteBuffer>> singleThreadedFloatBuffers;
        int currBufferNum;
        ResourceHolder<ByteBuffer> holder;
        FloatBuffer floatBuffer;

        private BlockLayoutColumnarFloats() {
            this.singleThreadedFloatBuffers = BlockLayoutColumnarFloatsSupplier.this.baseFloatBuffers.singleThreaded();
            this.currBufferNum = -1;
        }

        @Override
        public int size() {
            return BlockLayoutColumnarFloatsSupplier.this.totalSize;
        }

        @Override
        public float get(int index) {
            int bufferNum = index / BlockLayoutColumnarFloatsSupplier.this.sizePer;
            int bufferIndex = index % BlockLayoutColumnarFloatsSupplier.this.sizePer;
            if (bufferNum != this.currBufferNum) {
                this.loadBuffer(bufferNum);
            }
            return this.floatBuffer.get(bufferIndex);
        }

        @Override
        public void fill(int index, float[] toFill) {
            if (BlockLayoutColumnarFloatsSupplier.this.totalSize - index < toFill.length) {
                throw new IndexOutOfBoundsException(StringUtils.format((String)"Cannot fill array of size[%,d] at index[%,d].  Max size[%,d]", (Object[])new Object[]{toFill.length, index, BlockLayoutColumnarFloatsSupplier.this.totalSize}));
            }
            for (int i = 0; i < toFill.length; ++i) {
                toFill[i] = this.get(index + i);
            }
        }

        protected void loadBuffer(int bufferNum) {
            CloseQuietly.close(this.holder);
            this.holder = this.singleThreadedFloatBuffers.get(bufferNum);
            this.floatBuffer = ((ByteBuffer)this.holder.get()).asFloatBuffer();
            this.currBufferNum = bufferNum;
        }

        @Override
        public void close() {
            if (this.holder != null) {
                this.holder.close();
            }
        }

        public String toString() {
            return "BlockCompressedColumnarFloats_Anonymous{currBufferNum=" + this.currBufferNum + ", sizePer=" + BlockLayoutColumnarFloatsSupplier.this.sizePer + ", numChunks=" + this.singleThreadedFloatBuffers.size() + ", totalSize=" + BlockLayoutColumnarFloatsSupplier.this.totalSize + '}';
        }
    }
}

