/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.data.ColumnarLongsSerializer;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.serde.MetaSerdeHelper;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class BlockLayoutColumnarLongsSerializer
implements ColumnarLongsSerializer {
    private static final MetaSerdeHelper<BlockLayoutColumnarLongsSerializer> metaSerdeHelper = MetaSerdeHelper.firstWriteByte(x -> 2).writeInt(x -> x.numInserted).writeInt(x -> x.sizePer).writeSomething(CompressionFactory.longEncodingWriter(x -> x.writer, x -> x.compression));
    private final int sizePer;
    private final CompressionFactory.LongEncodingWriter writer;
    private final GenericIndexedWriter<ByteBuffer> flattener;
    private final CompressionStrategy compression;
    private int numInserted = 0;
    private int numInsertedForNextFlush;
    private ByteBuffer endBuffer;

    BlockLayoutColumnarLongsSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ByteOrder byteOrder, CompressionFactory.LongEncodingWriter writer, CompressionStrategy compression) {
        this.sizePer = writer.getBlockSize(65536);
        int bufferSize = writer.getNumBytes(this.sizePer);
        this.flattener = GenericIndexedWriter.ofCompressedByteBuffers(segmentWriteOutMedium, filenameBase, compression, bufferSize);
        this.writer = writer;
        this.compression = compression;
        CompressionStrategy.Compressor compressor = compression.getCompressor();
        this.endBuffer = compressor.allocateInBuffer(writer.getNumBytes(this.sizePer), segmentWriteOutMedium.getCloser()).order(byteOrder);
        writer.setBuffer(this.endBuffer);
        this.numInsertedForNextFlush = this.sizePer;
    }

    @Override
    public void open() throws IOException {
        this.flattener.open();
    }

    @Override
    public int size() {
        return this.numInserted;
    }

    @Override
    public void add(long value) throws IOException {
        if (this.endBuffer == null) {
            throw new IllegalStateException("written out already");
        }
        if (this.numInserted == this.numInsertedForNextFlush) {
            this.numInsertedForNextFlush += this.sizePer;
            this.writer.flush();
            this.endBuffer.flip();
            this.flattener.write(this.endBuffer);
            this.endBuffer.clear();
            this.writer.setBuffer(this.endBuffer);
        }
        this.writer.write(value);
        ++this.numInserted;
    }

    @Override
    public long getSerializedSize() throws IOException {
        this.writeEndBuffer();
        return (long)metaSerdeHelper.size(this) + this.flattener.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writeEndBuffer();
        metaSerdeHelper.writeTo(channel, this);
        this.flattener.writeTo(channel, smoosher);
    }

    private void writeEndBuffer() throws IOException {
        if (this.endBuffer != null) {
            this.writer.flush();
            this.endBuffer.flip();
            if (this.endBuffer.remaining() > 0) {
                this.flattener.write(this.endBuffer);
            }
            this.endBuffer = null;
        }
    }
}

