/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.Closeable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DoubleColumnSelector;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.historical.HistoricalColumnSelector;

public interface ColumnarDoubles
extends Closeable {
    public int size();

    public double get(int var1);

    @Override
    public void close();

    default public ColumnValueSelector<Double> makeColumnValueSelector(final ReadableOffset offset, final ImmutableBitmap nullValueBitmap) {
        if (nullValueBitmap.isEmpty()) {
            class HistoricalDoubleColumnSelector
            implements DoubleColumnSelector,
            HistoricalColumnSelector<Double> {
                HistoricalDoubleColumnSelector() {
                }

                @Override
                public boolean isNull() {
                    return false;
                }

                @Override
                public double getDouble() {
                    return ColumnarDoubles.this.get(offset.getOffset());
                }

                @Override
                public double getDouble(int offset2) {
                    return ColumnarDoubles.this.get(offset2);
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("columnar", ColumnarDoubles.this);
                    inspector.visit("offset", offset);
                }
            }
            return new HistoricalDoubleColumnSelector();
        }
        class HistoricalDoubleColumnSelectorWithNulls
        implements DoubleColumnSelector,
        HistoricalColumnSelector<Double> {
            HistoricalDoubleColumnSelectorWithNulls() {
            }

            @Override
            public boolean isNull() {
                return nullValueBitmap.get(offset.getOffset());
            }

            @Override
            public double getDouble() {
                assert (NullHandling.replaceWithDefault() || !this.isNull());
                return ColumnarDoubles.this.get(offset.getOffset());
            }

            @Override
            public double getDouble(int offset2) {
                assert (NullHandling.replaceWithDefault() || !nullValueBitmap.get(offset2));
                return ColumnarDoubles.this.get(offset2);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("columnar", ColumnarDoubles.this);
                inspector.visit("offset", offset);
                inspector.visit("nullValueBitmap", nullValueBitmap);
            }
        }
        return new HistoricalDoubleColumnSelectorWithNulls();
    }
}

