/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.Closeable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.FloatColumnSelector;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.historical.HistoricalColumnSelector;

public interface ColumnarFloats
extends Closeable {
    public int size();

    public float get(int var1);

    public void fill(int var1, float[] var2);

    @Override
    public void close();

    default public ColumnValueSelector<Float> makeColumnValueSelector(final ReadableOffset offset, final ImmutableBitmap nullValueBitmap) {
        if (nullValueBitmap.isEmpty()) {
            class HistoricalFloatColumnSelector
            implements FloatColumnSelector,
            HistoricalColumnSelector<Float> {
                HistoricalFloatColumnSelector() {
                }

                @Override
                public boolean isNull() {
                    return false;
                }

                @Override
                public float getFloat() {
                    return ColumnarFloats.this.get(offset.getOffset());
                }

                @Override
                public double getDouble(int offset2) {
                    return ColumnarFloats.this.get(offset2);
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("columnar", ColumnarFloats.this);
                    inspector.visit("offset", offset);
                }
            }
            return new HistoricalFloatColumnSelector();
        }
        class HistoricalFloatColumnSelectorwithNulls
        implements FloatColumnSelector,
        HistoricalColumnSelector<Float> {
            HistoricalFloatColumnSelectorwithNulls() {
            }

            @Override
            public boolean isNull() {
                return nullValueBitmap.get(offset.getOffset());
            }

            @Override
            public float getFloat() {
                assert (NullHandling.replaceWithDefault() || !this.isNull());
                return ColumnarFloats.this.get(offset.getOffset());
            }

            @Override
            public double getDouble(int offset2) {
                assert (NullHandling.replaceWithDefault() || !nullValueBitmap.get(offset2));
                return ColumnarFloats.this.get(offset2);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("columnar", ColumnarFloats.this);
                inspector.visit("offset", offset);
                inspector.visit("nullValueBitmap", nullValueBitmap);
            }
        }
        return new HistoricalFloatColumnSelectorwithNulls();
    }
}

