/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.data.IndexedInts;

public final class SliceIndexedInts
implements IndexedInts {
    private final IndexedInts base;
    private int offset = -1;
    private int size = -1;

    public SliceIndexedInts(IndexedInts base) {
        this.base = base;
    }

    public void setValues(int offset, int size) {
        this.offset = offset;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IAE("Index[%d] >= size[%d] or < 0", new Object[]{index, this.size});
        }
        return this.base.get(this.offset + index);
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("base", this.base);
    }
}

