/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.data.ColumnarMultiIntsSerializer;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.VSizeColumnarInts;
import org.apache.druid.segment.serde.MetaSerdeHelper;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.WriteOutBytes;

public class VSizeColumnarMultiIntsSerializer
extends ColumnarMultiIntsSerializer {
    private static final byte VERSION = 1;
    private static final MetaSerdeHelper<VSizeColumnarMultiIntsSerializer> metaSerdeHelper = MetaSerdeHelper.firstWriteByte(x -> 1).writeByte(x -> VSizeColumnarInts.getNumBytesForMax(x.maxId)).writeInt(x -> Ints.checkedCast((long)(x.headerOut.size() + x.valuesOut.size() + 4L))).writeInt(x -> x.numWritten);
    private final int maxId;
    private final WriteInt writeInt;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private WriteOutBytes headerOut = null;
    private WriteOutBytes valuesOut = null;
    private int numWritten = 0;
    private boolean numBytesForMaxWritten = false;

    public VSizeColumnarMultiIntsSerializer(SegmentWriteOutMedium segmentWriteOutMedium, int maxId) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.maxId = maxId;
        this.writeInt = WriteInt.values()[VSizeColumnarInts.getNumBytesForMax(maxId) - 1];
    }

    @Override
    public void open() throws IOException {
        this.headerOut = this.segmentWriteOutMedium.makeWriteOutBytes();
        this.valuesOut = this.segmentWriteOutMedium.makeWriteOutBytes();
    }

    @Override
    public void addValues(IndexedInts ints) throws IOException {
        if (this.numBytesForMaxWritten) {
            throw new IllegalStateException("written out already");
        }
        int size = ints.size();
        for (int i = 0; i < size; ++i) {
            int value = ints.get(i);
            Preconditions.checkState((value >= 0 && value <= this.maxId ? 1 : 0) != 0);
            this.writeInt.write(this.valuesOut, value);
        }
        this.headerOut.writeInt(Ints.checkedCast((long)this.valuesOut.size()));
        ++this.numWritten;
    }

    @Override
    public long getSerializedSize() throws IOException {
        this.writeNumBytesForMax();
        return (long)metaSerdeHelper.size(this) + this.headerOut.size() + this.valuesOut.size();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writeNumBytesForMax();
        long numBytesWritten = this.headerOut.size() + this.valuesOut.size();
        Preconditions.checkState((this.headerOut.size() == (long)(this.numWritten * 4) ? 1 : 0) != 0, (String)"numWritten[%s] number of rows should have [%s] bytes written to headerOut, had[%s]", (Object[])new Object[]{this.numWritten, this.numWritten * 4, this.headerOut.size()});
        Preconditions.checkState((numBytesWritten < 0x7FFFFFFBL ? 1 : 0) != 0, (String)"Wrote[%s] bytes, which is too many.", (Object[])new Object[]{numBytesWritten});
        metaSerdeHelper.writeTo(channel, this);
        this.headerOut.writeTo(channel);
        this.valuesOut.writeTo(channel);
    }

    private void writeNumBytesForMax() throws IOException {
        if (!this.numBytesForMaxWritten) {
            byte numBytesForMax = VSizeColumnarInts.getNumBytesForMax(this.maxId);
            this.valuesOut.write(new byte[4 - numBytesForMax]);
            this.numBytesForMaxWritten = true;
        }
    }

    private static enum WriteInt {
        ONE_BYTE{

            @Override
            void write(WriteOutBytes out, int v) throws IOException {
                out.write(v);
            }
        }
        ,
        TWO_BYTES{

            @Override
            void write(WriteOutBytes out, int v) throws IOException {
                out.write(v >> 8);
                out.write(v);
            }
        }
        ,
        THREE_BYTES{

            @Override
            void write(WriteOutBytes out, int v) throws IOException {
                out.write(v >> 16);
                out.write(v >> 8);
                out.write(v);
            }
        }
        ,
        FOUR_BYTES{

            @Override
            void write(WriteOutBytes out, int v) throws IOException {
                out.writeInt(v);
            }
        };


        abstract void write(WriteOutBytes var1, int var2) throws IOException;
    }
}

