/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.RowNumCounter;
import org.apache.druid.segment.RowPointer;
import org.apache.druid.segment.TimeAndDimsPointer;
import org.apache.druid.segment.TransformableRowIterator;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexColumnSelectorFactory;
import org.apache.druid.segment.incremental.IncrementalIndexRow;
import org.apache.druid.segment.incremental.IncrementalIndexRowHolder;

class IncrementalIndexRowIterator
implements TransformableRowIterator {
    private final Iterator<IncrementalIndexRow> timeAndDimsIterator;
    private final IncrementalIndexRowHolder currentRowHolder = new IncrementalIndexRowHolder();
    private final IncrementalIndexRowHolder markedRowHolder = new IncrementalIndexRowHolder();
    private final RowNumCounter currentRowNumCounter = new RowNumCounter(-1);
    private final RowPointer currentRowPointer;
    private final TimeAndDimsPointer markedRowPointer;

    IncrementalIndexRowIterator(IncrementalIndex<?> incrementalIndex) {
        this.timeAndDimsIterator = incrementalIndex.getFacts().persistIterable().iterator();
        this.currentRowPointer = IncrementalIndexRowIterator.makeRowPointer(incrementalIndex, this.currentRowHolder, this.currentRowNumCounter);
        this.markedRowPointer = IncrementalIndexRowIterator.makeRowPointer(incrementalIndex, this.markedRowHolder, new RowNumCounter());
    }

    private static RowPointer makeRowPointer(IncrementalIndex<?> incrementalIndex, IncrementalIndexRowHolder rowHolder, RowNumCounter rowNumCounter) {
        IncrementalIndexColumnSelectorFactory columnSelectorFactory = new IncrementalIndexColumnSelectorFactory(incrementalIndex, VirtualColumns.EMPTY, false, rowHolder);
        ColumnValueSelector[] dimensionSelectors = (ColumnValueSelector[])incrementalIndex.getDimensions().stream().map(dim -> {
            ColumnValueSelector selectorWithUnsortedValues = columnSelectorFactory.makeColumnValueSelector(dim.getName());
            return dim.getIndexer().convertUnsortedValuesToSorted(selectorWithUnsortedValues);
        }).toArray(ColumnValueSelector[]::new);
        List<DimensionHandler> dimensionHandlers = incrementalIndex.getDimensions().stream().map(IncrementalIndex.DimensionDesc::getHandler).collect(Collectors.toList());
        ColumnValueSelector[] metricSelectors = (ColumnValueSelector[])incrementalIndex.getMetricNames().stream().map(columnSelectorFactory::makeColumnValueSelector).toArray(ColumnValueSelector[]::new);
        return new RowPointer(rowHolder, dimensionSelectors, dimensionHandlers, metricSelectors, incrementalIndex.getMetricNames(), rowNumCounter);
    }

    @Override
    public boolean moveToNext() {
        if (!this.timeAndDimsIterator.hasNext()) {
            return false;
        }
        this.currentRowHolder.set(this.timeAndDimsIterator.next());
        this.currentRowNumCounter.increment();
        return true;
    }

    @Override
    public RowPointer getPointer() {
        return this.currentRowPointer;
    }

    @Override
    public void mark() {
        this.markedRowHolder.set(this.currentRowHolder.get());
    }

    @Override
    public TimeAndDimsPointer getMarkedPointer() {
        return this.markedRowPointer;
    }

    @Override
    public boolean hasTimeAndDimsChangedSinceMark() {
        return !Objects.equals(this.markedRowHolder.get(), this.currentRowHolder.get());
    }

    @Override
    public void close() {
    }
}

