/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Supplier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.ColumnarDoubles;
import org.apache.druid.segment.data.CompressedColumnarDoublesSuppliers;
import org.apache.druid.segment.serde.ColumnPartSerde;
import org.apache.druid.segment.serde.DoubleNumericColumnSupplier;
import org.apache.druid.segment.serde.Serializer;

public class DoubleNumericColumnPartSerde
implements ColumnPartSerde {
    private final ByteOrder byteOrder;
    @Nullable
    private final Serializer serializer;

    @JsonCreator
    public static DoubleNumericColumnPartSerde getDoubleGenericColumnPartSerde(@JsonProperty(value="byteOrder") ByteOrder byteOrder) {
        return new DoubleNumericColumnPartSerde(byteOrder, null);
    }

    private DoubleNumericColumnPartSerde(ByteOrder byteOrder, @Nullable Serializer serializer) {
        this.byteOrder = byteOrder;
        this.serializer = serializer;
    }

    @JsonProperty
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public static SerializerBuilder serializerBuilder() {
        return new SerializerBuilder();
    }

    @Override
    @Nullable
    public Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public ColumnPartSerde.Deserializer getDeserializer() {
        return new ColumnPartSerde.Deserializer(){

            @Override
            public void read(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
                Supplier<ColumnarDoubles> column = CompressedColumnarDoublesSuppliers.fromByteBuffer(buffer, DoubleNumericColumnPartSerde.this.byteOrder);
                DoubleNumericColumnSupplier columnSupplier = new DoubleNumericColumnSupplier(column, IndexIO.LEGACY_FACTORY.getBitmapFactory().makeEmptyImmutableBitmap());
                builder.setType(ValueType.DOUBLE).setHasMultipleValues(false).setNumericColumnSupplier(columnSupplier);
            }
        };
    }

    public static class SerializerBuilder {
        private ByteOrder byteOrder = null;
        private Serializer delegate = null;

        public SerializerBuilder withByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public SerializerBuilder withDelegate(Serializer delegate) {
            this.delegate = delegate;
            return this;
        }

        public DoubleNumericColumnPartSerde build() {
            return new DoubleNumericColumnPartSerde(this.byteOrder, this.delegate);
        }
    }
}

