/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.BitmapSerde;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.CompressedColumnarLongsSupplier;
import org.apache.druid.segment.serde.ColumnPartSerde;
import org.apache.druid.segment.serde.LongNumericColumnSupplier;
import org.apache.druid.segment.serde.Serializer;

public class LongNumericColumnPartSerdeV2
implements ColumnPartSerde {
    private final ByteOrder byteOrder;
    @Nullable
    private Serializer serializer;
    private final BitmapSerdeFactory bitmapSerdeFactory;

    @JsonCreator
    public static LongNumericColumnPartSerdeV2 createDeserializer(@JsonProperty(value="byteOrder") ByteOrder byteOrder, @Nullable @JsonProperty(value="bitmapSerdeFactory") BitmapSerdeFactory bitmapSerdeFactory) {
        return new LongNumericColumnPartSerdeV2(byteOrder, bitmapSerdeFactory != null ? bitmapSerdeFactory : new BitmapSerde.LegacyBitmapSerdeFactory(), null);
    }

    private LongNumericColumnPartSerdeV2(ByteOrder byteOrder, BitmapSerdeFactory bitmapSerdeFactory, @Nullable Serializer serializer) {
        this.byteOrder = byteOrder;
        this.bitmapSerdeFactory = bitmapSerdeFactory;
        this.serializer = serializer;
    }

    @JsonProperty
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @JsonProperty
    public BitmapSerdeFactory getBitmapSerdeFactory() {
        return this.bitmapSerdeFactory;
    }

    public static SerializerBuilder serializerBuilder() {
        return new SerializerBuilder();
    }

    @Override
    @Nullable
    public Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public ColumnPartSerde.Deserializer getDeserializer() {
        return (buffer, builder, columnConfig) -> {
            int offset = buffer.getInt();
            int initialPos = buffer.position();
            CompressedColumnarLongsSupplier column = CompressedColumnarLongsSupplier.fromByteBuffer(buffer, this.byteOrder);
            buffer.position(initialPos + offset);
            ImmutableBitmap bitmap = buffer.hasRemaining() ? this.bitmapSerdeFactory.getObjectStrategy().fromByteBufferWithSize(buffer) : this.bitmapSerdeFactory.getBitmapFactory().makeEmptyImmutableBitmap();
            builder.setType(ValueType.LONG).setHasMultipleValues(false).setNumericColumnSupplier(new LongNumericColumnSupplier(column, bitmap));
        };
    }

    public static class SerializerBuilder {
        private ByteOrder byteOrder = null;
        private Serializer delegate = null;
        private BitmapSerdeFactory bitmapSerdeFactory = null;

        public SerializerBuilder withByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public SerializerBuilder withDelegate(Serializer delegate) {
            this.delegate = delegate;
            return this;
        }

        public SerializerBuilder withBitmapSerdeFactory(BitmapSerdeFactory bitmapSerdeFactory) {
            this.bitmapSerdeFactory = bitmapSerdeFactory;
            return this;
        }

        public LongNumericColumnPartSerdeV2 build() {
            Serializer serializer = new Serializer(){

                @Override
                public long getSerializedSize() throws IOException {
                    return delegate.getSerializedSize();
                }

                @Override
                public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
                    delegate.writeTo(channel, smoosher);
                }
            };
            return new LongNumericColumnPartSerdeV2(this.byteOrder, this.bitmapSerdeFactory, serializer);
        }
    }
}

