/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;

public class ExpressionColumnValueSelector
implements ColumnValueSelector<ExprEval> {
    private final Expr.ObjectBinding bindings;
    private final Expr expression;

    public ExpressionColumnValueSelector(Expr expression, Expr.ObjectBinding bindings) {
        this.bindings = (Expr.ObjectBinding)Preconditions.checkNotNull((Object)bindings, (Object)"bindings");
        this.expression = (Expr)Preconditions.checkNotNull((Object)expression, (Object)"expression");
    }

    @Override
    public double getDouble() {
        return this.getObject().asDouble();
    }

    @Override
    public float getFloat() {
        return (float)this.getObject().asDouble();
    }

    @Override
    public long getLong() {
        return this.getObject().asLong();
    }

    @Override
    public Class<ExprEval> classOfObject() {
        return ExprEval.class;
    }

    @Override
    @Nonnull
    public ExprEval getObject() {
        return this.expression.eval(this.bindings);
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("expression", this.expression);
        inspector.visit("bindings", this.bindings);
    }

    @Override
    public boolean isNull() {
        return this.getObject().isNumericNull();
    }
}

