/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.writeout;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.FileUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.writeout.FileWriteOutBytes;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.WriteOutBytes;

public final class TmpFileSegmentWriteOutMedium
implements SegmentWriteOutMedium {
    private final File dir;
    private final Closer closer = Closer.create();

    TmpFileSegmentWriteOutMedium(File outDir) throws IOException {
        File tmpOutputFilesDir = new File(outDir, "tmpOutputFiles");
        FileUtils.forceMkdir((File)tmpOutputFilesDir);
        this.closer.register(() -> FileUtils.deleteDirectory((File)tmpOutputFilesDir));
        this.dir = tmpOutputFilesDir;
    }

    @Override
    public WriteOutBytes makeWriteOutBytes() throws IOException {
        File file = File.createTempFile("filePeon", null, this.dir);
        FileChannel ch = FileChannel.open(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.closer.register(file::delete);
        this.closer.register((Closeable)ch);
        return new FileWriteOutBytes(file, ch);
    }

    @Override
    public Closer getCloser() {
        return this.closer;
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }
}

