/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections.bitmap;

import com.google.common.base.Throwables;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.collections.bitmap.WrappedImmutableRoaringBitmap;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.RoaringBitmapWriter;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class WrappedRoaringBitmap
implements MutableBitmap {
    private final boolean compressRunOnSerialization;
    private RoaringBitmapWriter<MutableRoaringBitmap> writer = RoaringBitmapWriter.bufferWriter().get();

    public WrappedRoaringBitmap() {
        this(false);
    }

    public WrappedRoaringBitmap(boolean compressRunOnSerialization) {
        this.compressRunOnSerialization = compressRunOnSerialization;
    }

    ImmutableBitmap toImmutableBitmap() {
        MutableRoaringBitmap bitmap = ((MutableRoaringBitmap)this.writer.get()).clone();
        if (this.compressRunOnSerialization) {
            bitmap.runOptimize();
        }
        return new WrappedImmutableRoaringBitmap(bitmap.toImmutableRoaringBitmap());
    }

    @Override
    public byte[] toBytes() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            MutableRoaringBitmap bitmap = (MutableRoaringBitmap)this.writer.get();
            if (this.compressRunOnSerialization) {
                bitmap.runOptimize();
            }
            bitmap.serialize((DataOutput)new DataOutputStream(out));
            return out.toByteArray();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void clear() {
        this.writer.reset();
    }

    @Override
    public void or(MutableBitmap mutableBitmap) {
        WrappedRoaringBitmap other = (WrappedRoaringBitmap)mutableBitmap;
        MutableRoaringBitmap unwrappedOtherBitmap = (MutableRoaringBitmap)other.writer.get();
        ((MutableRoaringBitmap)this.writer.get()).or((ImmutableRoaringBitmap)unwrappedOtherBitmap);
    }

    @Override
    public int getSizeInBytes() {
        MutableRoaringBitmap bitmap = (MutableRoaringBitmap)this.writer.get();
        if (this.compressRunOnSerialization) {
            bitmap.runOptimize();
        }
        return bitmap.serializedSizeInBytes();
    }

    @Override
    public void add(int entry) {
        this.writer.add(entry);
    }

    @Override
    public int size() {
        return ((MutableRoaringBitmap)this.writer.get()).getCardinality();
    }

    public void serialize(ByteBuffer buffer) {
        try {
            MutableRoaringBitmap bitmap = (MutableRoaringBitmap)this.writer.get();
            if (this.compressRunOnSerialization) {
                bitmap.runOptimize();
            }
            bitmap.serialize((DataOutput)new DataOutputStream(new OutputStream(){
                ByteBuffer mBB;

                OutputStream init(ByteBuffer mbb) {
                    this.mBB = mbb;
                    return this;
                }

                @Override
                public void close() {
                }

                @Override
                public void flush() {
                }

                @Override
                public void write(int b) {
                    this.mBB.put((byte)b);
                }

                @Override
                public void write(byte[] b) {
                    this.mBB.put(b);
                }

                @Override
                public void write(byte[] b, int off, int l) {
                    this.mBB.put(b, off, l);
                }
            }.init(buffer)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.writer.getUnderlying();
    }

    @Override
    public void remove(int entry) {
        ((MutableRoaringBitmap)this.writer.get()).remove(entry);
    }

    @Override
    public IntIterator iterator() {
        return ((MutableRoaringBitmap)this.writer.get()).getIntIterator();
    }

    @Override
    public boolean isEmpty() {
        return ((MutableRoaringBitmap)this.writer.get()).isEmpty();
    }

    @Override
    public ImmutableBitmap intersection(ImmutableBitmap otherBitmap) {
        WrappedRoaringBitmap other = (WrappedRoaringBitmap)otherBitmap;
        MutableRoaringBitmap unwrappedOtherBitmap = (MutableRoaringBitmap)other.writer.get();
        return new WrappedImmutableRoaringBitmap((ImmutableRoaringBitmap)MutableRoaringBitmap.and((MutableRoaringBitmap)((MutableRoaringBitmap)this.writer.get()), (MutableRoaringBitmap)unwrappedOtherBitmap));
    }

    @Override
    public boolean get(int value) {
        return ((MutableRoaringBitmap)this.writer.get()).contains(value);
    }
}

